/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class LabelsValidator
implements ClauseValidator {
    private final JqlOperandResolver operandResolver;

    public LabelsValidator(JqlOperandResolver operandResolver) {
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
    }

    public MessageSet validate(User searcher, TerminalClause terminalClause) {
        MessageSetImpl messageSet = new MessageSetImpl();
        I18nHelper i18n = this.getI18n(searcher);
        Operator operator = terminalClause.getOperator();
        String fieldName = terminalClause.getName();
        if (!this.handlesOperator(operator)) {
            messageSet.addErrorMessage(i18n.getText("jira.jql.clause.does.not.support.operator", operator.getDisplayString(), fieldName));
            return messageSet;
        }
        Operand operand = terminalClause.getOperand();
        List values = this.operandResolver.getValues(searcher, operand, terminalClause);
        if (values != null) {
            for (QueryLiteral literal : values) {
                String query;
                if (literal.isEmpty() || !StringUtils.isNotBlank((String)(query = literal.asString()))) continue;
                String label = query.trim();
                if (!LabelParser.isValidLabelName((String)label)) {
                    messageSet.addErrorMessage(i18n.getText("label.service.error.label.invalid", label));
                }
                if (label.length() <= 255) continue;
                messageSet.addErrorMessage(i18n.getText("label.service.error.label.toolong", label));
            }
        }
        return messageSet;
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }

    I18nHelper getI18n(User user) {
        return new I18nBean(user);
    }
}

