/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import org.ofbiz.core.entity.GenericValue;

@InjectableComponent
public class ProjectCategoryResolver {
    private final ProjectManager projectManager;

    public ProjectCategoryResolver(ProjectManager projectManager) {
        this.projectManager = (ProjectManager)Assertions.notNull((String)"projectManager", (Object)projectManager);
    }

    public GenericValue getProjectCategory(QueryLiteral literal) {
        Assertions.notNull((String)"literal", (Object)literal);
        if (literal.getStringValue() != null) {
            return this.getProjectCategoryForString(literal.getStringValue());
        }
        if (literal.getLongValue() != null) {
            return this.getProjectCategoryForLong(literal.getLongValue());
        }
        return null;
    }

    public Collection<Project> getProjectsForCategory(QueryLiteral literal) {
        Assertions.notNull((String)"literal", (Object)literal);
        if (literal.isEmpty()) {
            return this.projectManager.getProjectObjectsWithNoCategory();
        }
        GenericValue category = this.getProjectCategory(literal);
        return category != null ? this.projectManager.getProjectObjectsFromProjectCategory(category.getLong("id")) : Collections.emptySet();
    }

    private GenericValue getProjectCategoryForString(String rawValue) {
        Long valueAsLong;
        GenericValue category = this.getProjectCategoryByName(rawValue);
        if (category == null && (valueAsLong = this.getValueAsLong(rawValue)) != null) {
            category = this.getProjectCategoryById(valueAsLong);
        }
        return category;
    }

    private GenericValue getProjectCategoryForLong(Long longValue) {
        GenericValue category = this.getProjectCategoryById(longValue);
        if (category == null) {
            category = this.getProjectCategoryByName(longValue.toString());
        }
        return category;
    }

    private GenericValue getProjectCategoryByName(String rawValue) {
        return this.projectManager.getProjectCategoryByNameIgnoreCase(rawValue);
    }

    private GenericValue getProjectCategoryById(Long rawValue) {
        return this.projectManager.getProjectCategory(rawValue);
    }

    private Long getValueAsLong(String singleValueOperand) {
        try {
            return new Long(singleValueOperand);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

