/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.ClauseTooComplexSearchException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.util.LuceneQueryModifier;
import com.atlassian.jira.jql.query.LuceneQueryBuilder;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryRegistry;
import com.atlassian.jira.jql.query.QueryVisitor;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.query.clause.Clause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

@InjectableComponent
public class DefaultLuceneQueryBuilder
implements LuceneQueryBuilder {
    private final QueryRegistry queryRegistry;
    private final LuceneQueryModifier luceneQueryModifier;

    public DefaultLuceneQueryBuilder(QueryRegistry queryRegistry, LuceneQueryModifier luceneQueryModifier) {
        this.queryRegistry = queryRegistry;
        this.luceneQueryModifier = luceneQueryModifier;
    }

    @Override
    public Query createLuceneQuery(QueryCreationContext queryCreationContext, Clause clause) throws SearchException {
        Query luceneQuery;
        QueryVisitor queryVisitor = this.createQueryVisitor(queryCreationContext);
        try {
            luceneQuery = queryVisitor.createQuery(clause);
        }
        catch (QueryVisitor.JqlTooComplex jqlTooComplex) {
            throw new ClauseTooComplexSearchException(jqlTooComplex.getClause());
        }
        try {
            return this.luceneQueryModifier.getModifiedQuery(luceneQuery);
        }
        catch (BooleanQuery.TooManyClauses tooManyClauses) {
            throw new ClauseTooComplexSearchException(clause);
        }
    }

    QueryVisitor createQueryVisitor(QueryCreationContext context) {
        return new QueryVisitor(this.queryRegistry, context);
    }
}

