/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.service;

import com.atlassian.jira.jelly.JiraJelly;
import com.atlassian.jira.jelly.WebWorkAdaptor;
import com.atlassian.jira.jelly.service.JellyServiceException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.parser.XMLParser;
import org.apache.log4j.Logger;

public class EmbededJellyContext
extends JellyContext {
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private final WebWorkAdaptor webWorkAdaptor = new WebWorkAdaptor();

    public EmbededJellyContext() {
        this.setUseContextClassLoader(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JellyContext runScript(String jellyFilename, String outputFilename) throws Exception {
        JellyContext jellyContext = null;
        if (jellyFilename == null) {
            throw new IllegalArgumentException("null Jelly filename");
        }
        if (outputFilename == null) {
            throw new IllegalArgumentException("null output filename");
        }
        File jellyScriptFile = new File(jellyFilename);
        if (!jellyScriptFile.exists()) {
            return null;
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(outputFilename);
            XMLOutput xmlOutput = XMLOutput.createXMLOutput((Writer)fileWriter);
            try {
                jellyContext = this.runScript(jellyScriptFile, xmlOutput);
            }
            catch (JellyException e) {
                fileWriter.write("\n" + e.getMessage());
                throw e;
            }
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException ignore) {}
        }
        return jellyContext;
    }

    public JellyContext runScriptAsString(String scriptAsString, XMLOutput output) throws JellyServiceException {
        if (JiraJelly.allowedToRun()) {
            try {
                XMLParser parse = new XMLParser();
                Script script = parse.parse((Reader)new StringReader(scriptAsString));
                JellyContext newJellyContext = new JellyContext((JellyContext)this);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("running script : " + scriptAsString));
                }
                script.run(newJellyContext, output);
                return newJellyContext;
            }
            catch (Exception e) {
                throw new JellyServiceException(e);
            }
        }
        throw new UnsupportedOperationException("Can not run script because jelly is not turned on.");
    }

    public JellyContext runScript(String scriptAsString, Writer outputWriter) throws JellyServiceException {
        return this.runScriptAsString(scriptAsString, XMLOutput.createXMLOutput((Writer)outputWriter));
    }

    public JellyContext runScript(File file, XMLOutput xmlOutput) throws JellyException {
        if (JiraJelly.allowedToRun()) {
            return super.runScript(file, xmlOutput);
        }
        throw new UnsupportedOperationException("Can not run script because jelly is not turned on.");
    }

    public JellyContext runScript(URL url, XMLOutput xmlOutput) throws JellyException {
        if (JiraJelly.allowedToRun()) {
            return super.runScript(url, xmlOutput);
        }
        throw new UnsupportedOperationException("Can not run script because jelly is not turned on.");
    }

    public JellyContext runScript(String string, XMLOutput xmlOutput) throws JellyException {
        if (JiraJelly.allowedToRun()) {
            return super.runScript(string, xmlOutput);
        }
        throw new UnsupportedOperationException("Can not run script because jelly is not turned on.");
    }

    public JellyContext runScript(String string, XMLOutput xmlOutput, boolean b, boolean b1) throws JellyException {
        if (JiraJelly.allowedToRun()) {
            return super.runScript(string, xmlOutput);
        }
        throw new UnsupportedOperationException("Can not run script because jelly is not turned on.");
    }

    public JellyContext runScript(File file, XMLOutput xmlOutput, boolean b, boolean b1) throws JellyException {
        if (JiraJelly.allowedToRun()) {
            return super.runScript(file, xmlOutput, b, b1);
        }
        throw new UnsupportedOperationException("Can not run script because jelly is not turned on.");
    }

    public JellyContext runScript(URL url, XMLOutput xmlOutput, boolean b, boolean b1) throws JellyException {
        if (JiraJelly.allowedToRun()) {
            return super.runScript(url, xmlOutput, b, b1);
        }
        throw new UnsupportedOperationException("Can not run script because jelly is not turned on.");
    }

    public WebWorkAdaptor getWebWorkAdaptor() {
        return this.webWorkAdaptor;
    }
}

