/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;

public class DefaultIssueUpdater
implements IssueUpdater {
    private final OfBizDelegator ofBizDelegator;
    private final IssueEventManager issueEventManager;

    public DefaultIssueUpdater(OfBizDelegator ofBizDelegator, IssueEventManager issueEventManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.issueEventManager = issueEventManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdate(IssueUpdateBean iub, boolean generateChangeItems) {
        GenericValue changedIssue = iub.getChangedIssue();
        changedIssue.set("updated", (Object)UtilDateTime.nowTimestamp());
        ArrayList<ChangeItemBean> modifiedFields = new ArrayList<ChangeItemBean>();
        modifiedFields.addAll(ChangeLogUtils.generateChangeItems(iub.getOriginalIssue(), changedIssue));
        if (iub.getChangeItems() != null) {
            modifiedFields.addAll(iub.getChangeItems());
        }
        GenericValue updateIssueGV = new GenericValue(changedIssue.getDelegator(), changedIssue.getModelEntity());
        updateIssueGV.setPKFields(changedIssue.getPrimaryKey().getAllFields());
        for (ChangeItemBean modifiedField : modifiedFields) {
            String fieldName = modifiedField.getField();
            if ("issuetype".equals(fieldName)) {
                fieldName = "type";
            }
            if (!updateIssueGV.getModelEntity().isField(fieldName)) continue;
            updateIssueGV.put(fieldName, changedIssue.get(fieldName));
        }
        updateIssueGV.put("updated", changedIssue.get("updated"));
        Transaction txn = Txn.begin();
        try {
            this.ofBizDelegator.storeAll((List)ImmutableList.of((Object)updateIssueGV));
            GenericValue changeGroup = ChangeLogUtils.createChangeGroup(iub.getUser(), iub.getOriginalIssue(), changedIssue, (Collection<ChangeItemBean>)iub.getChangeItems(), generateChangeItems);
            txn.commit();
            if ((changeGroup != null || iub.getComment() != null) && iub.isDispatchEvent()) {
                GenericValue updatedIssue = this.ofBizDelegator.findByPrimaryKey("Issue", updateIssueGV.getLong("id"));
                IssueFactory issueFactory = ComponentManager.getComponentInstanceOfType(IssueFactory.class);
                this.issueEventManager.dispatchEvent(iub.getEventTypeId(), (Issue)issueFactory.getIssue(updatedIssue), iub.getUser(), iub.getComment(), iub.getWorklog(), changeGroup, iub.getParams(), iub.isSendMail(), iub.isSubtasksUpdated());
            }
        }
        finally {
            txn.finallyRollbackIfNotCommitted();
        }
    }
}

