/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.action.IssueActionComparator;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.issue.tabpanels.WorklogAction;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WorklogTabPanel
extends AbstractIssueTabPanel {
    private final WorklogService worklogService;
    private final JiraDurationUtils jiraDurationUtils;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final ApplicationProperties applicationProperties;
    private final FieldVisibilityManager fieldVisibilityManager;

    public WorklogTabPanel(WorklogService worklogService, JiraDurationUtils jiraDurationUtils, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, ApplicationProperties applicationProperties, FieldVisibilityManager fieldVisibilityManager) {
        this.worklogService = worklogService;
        this.jiraDurationUtils = jiraDurationUtils;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.applicationProperties = applicationProperties;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public List<IssueAction> getActions(Issue issue, User remoteUser) {
        JiraServiceContextImpl context = new JiraServiceContextImpl(remoteUser, (ErrorCollection)new SimpleErrorCollection());
        List userWorklogs = this.worklogService.getByIssueVisibleToUser((JiraServiceContext)context, issue);
        ArrayList worklogs = Lists.newArrayList();
        for (Worklog userWorklog : userWorklogs) {
            boolean canEditWorklog = this.worklogService.hasPermissionToUpdate((JiraServiceContext)context, userWorklog);
            boolean canDeleteWorklog = this.worklogService.hasPermissionToDelete((JiraServiceContext)context, userWorklog);
            worklogs.add(new WorklogAction(this.descriptor, userWorklog, this.jiraDurationUtils, canEditWorklog, canDeleteWorklog, this.fieldLayoutManager, this.rendererManager));
        }
        if (worklogs.isEmpty()) {
            GenericMessageAction action = new GenericMessageAction(this.descriptor.getI18nBean().getText("viewissue.nowork"));
            return Lists.newArrayList((Object[])new IssueAction[]{action});
        }
        Collections.sort(worklogs, IssueActionComparator.COMPARATOR);
        return worklogs;
    }

    public boolean showPanel(Issue issue, User remoteUser) {
        return this.applicationProperties.getOption("jira.option.timetracking") && this.fieldVisibilityManager.isFieldVisible("timetracking", issue);
    }
}

