/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.statistics.StatsGroup;
import com.atlassian.jira.issue.statistics.util.AbstractOneDimensionalHitCollector;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;

public class OneDimensionalDocIssueHitCollector
extends AbstractOneDimensionalHitCollector {
    private final StatsGroup statsGroup;
    private final IndexReader searcher;
    private final IssueFactory issueFactory;

    public OneDimensionalDocIssueHitCollector(String luceneGroupField, StatsGroup statsGroup, IndexReader searcher, IssueFactory issueFactory, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache) {
        super(luceneGroupField, fieldVisibilityManager, readerCache);
        this.statsGroup = statsGroup;
        this.searcher = searcher;
        this.issueFactory = issueFactory;
    }

    protected void collectIrrelevant(int docId) {
        Document issueDocument = this.getDocument(docId);
        if (issueDocument != null) {
            Issue issue = this.issueFactory.getIssue(issueDocument);
            this.statsGroup.addIrrelevantIssue(issue);
        }
    }

    protected void collectWithTerms(int docId, Collection<String> terms) {
        Document issueDocument = this.getDocument(docId);
        if (issueDocument != null) {
            this.adjustMapForIssueKey(this.statsGroup, terms, issueDocument);
        }
    }

    private Document getDocument(int docId) {
        try {
            return this.searcher.document(docId);
        }
        catch (IOException e) {
            return null;
        }
    }

    private void adjustMapForIssueKey(StatsGroup statsGroup, Collection<String> values, Document issueDocument) {
        Issue issue = this.issueFactory.getIssue(issueDocument);
        if (values == null) {
            statsGroup.addValue(null, issue);
            return;
        }
        for (String value : values) {
            statsGroup.addValue(value, issue);
        }
    }
}

