/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import com.atlassian.jira.issue.search.quicksearch.SingleWordQuickSearchHandler;
import java.util.Collection;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class PriorityQuickSearchHandler
extends SingleWordQuickSearchHandler {
    public final ConstantsManager constantsManager;

    public PriorityQuickSearchHandler(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    @Override
    protected Map handleWord(String word, QuickSearchResult searchResult) {
        GenericValue statusByName = this.getPriorityByName(word);
        return statusByName != null ? EasyMap.build((Object)"priority", (Object)statusByName.getString("id")) : null;
    }

    private GenericValue getPriorityByName(String name) {
        Collection statuses = this.constantsManager.getPriorities();
        return PriorityQuickSearchHandler.getByName(statuses, name);
    }
}

