/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.MultiHashMap;

public class ModifiableQuickSearchResult
implements QuickSearchResult {
    private final Map searchParams = new MultiHashMap();
    private String searchInput;

    public ModifiableQuickSearchResult(String searchInput) {
        this.searchInput = searchInput;
    }

    @Override
    public String getQueryString() {
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry entry : this.searchParams.entrySet()) {
            String key = (String)entry.getKey();
            Collection values = (Collection)entry.getValue();
            for (String value : values) {
                queryString.append("&" + key + "=" + value);
            }
        }
        return queryString.toString();
    }

    @Override
    public void addSearchParameter(String key, String value) {
        this.searchParams.put(key, value);
    }

    @Override
    public Collection getSearchParameters(String key) {
        return (Collection)this.searchParams.get(key);
    }

    @Override
    public String getSearchInput() {
        return this.searchInput;
    }

    @Override
    public void setSearchInput(String searchInput) {
        this.searchInput = searchInput;
    }
}

