/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import com.atlassian.jira.issue.search.quicksearch.SingleWordQuickSearchHandler;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class IssueTypeQuickSearchHandler
extends SingleWordQuickSearchHandler {
    public final ConstantsManager constantsManager;

    public IssueTypeQuickSearchHandler(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    public GenericValue getTypeByName(String name) {
        return IssueTypeQuickSearchHandler.getByName(this.constantsManager.getIssueTypes(), name);
    }

    @Override
    protected Map handleWord(String word, QuickSearchResult searchResult) {
        GenericValue typeByName = this.getTypeByName(word);
        if (typeByName == null && (word.endsWith("S") || word.endsWith("s"))) {
            typeByName = this.getTypeByName(word.substring(0, word.length() - 1));
        }
        return typeByName != null ? EasyMap.build((Object)"type", (Object)typeByName.getString("id")) : null;
    }
}

