/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.providers;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.parameters.lucene.CachedWrappedFilterCache;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterGenerator;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.jql.query.LuceneQueryBuilder;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.filters.ThreadLocalQueryProfiler;
import com.atlassian.query.order.SearchSort;
import com.atlassian.query.order.SortOrder;
import com.atlassian.util.profiling.UtilTimerStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHitCountCollector;

public class LuceneSearchProvider
implements SearchProvider {
    private static final Logger log = Logger.getLogger(LuceneSearchProvider.class);
    private static final Logger slowLog = Logger.getLogger((String)(LuceneSearchProvider.class.getName() + "_SLOW"));
    private final SearchProviderFactory searchProviderFactory;
    private final IssueFactory issueFactory;
    private final PermissionsFilterGenerator permissionsFilterGenerator;
    private final SearchHandlerManager searchHandlerManager;
    private final SearchSortUtil searchSortUtil;
    private final LuceneQueryBuilder luceneQueryBuilder;

    public LuceneSearchProvider(IssueFactory issueFactory, SearchProviderFactory searchProviderFactory, PermissionsFilterGenerator permissionsFilterGenerator, SearchHandlerManager searchHandlerManager, SearchSortUtil searchSortUtil, LuceneQueryBuilder luceneQueryBuilder) {
        this.issueFactory = issueFactory;
        this.searchProviderFactory = searchProviderFactory;
        this.permissionsFilterGenerator = permissionsFilterGenerator;
        this.searchHandlerManager = searchHandlerManager;
        this.searchSortUtil = searchSortUtil;
        this.luceneQueryBuilder = luceneQueryBuilder;
    }

    public SearchResults search(com.atlassian.query.Query query, User searcher, PagerFilter pager) throws SearchException {
        return this.search(query, searcher, pager, null);
    }

    public SearchResults search(com.atlassian.query.Query query, User searcher, PagerFilter pager, Query andQuery) throws SearchException {
        return this.search(query, searcher, pager, andQuery, false);
    }

    public SearchResults searchOverrideSecurity(com.atlassian.query.Query query, User searcher, PagerFilter pager, Query andQuery) throws SearchException {
        return this.search(query, searcher, pager, andQuery, true);
    }

    public long searchCount(com.atlassian.query.Query query, User user) throws SearchException {
        IndexSearcher issueSearcher = this.searchProviderFactory.getSearcher("issues");
        return this.getHitCount(query, user, null, null, false, issueSearcher, null);
    }

    public long searchCountOverrideSecurity(com.atlassian.query.Query query, User user) throws SearchException {
        IndexSearcher issueSearcher = this.searchProviderFactory.getSearcher("issues");
        return this.getHitCount(query, user, null, null, true, issueSearcher, null);
    }

    public void search(com.atlassian.query.Query query, User user, Collector collector) throws SearchException {
        this.search(query, user, collector, null, false);
    }

    public void search(com.atlassian.query.Query query, User searcher, Collector collector, Query andQuery) throws SearchException {
        this.search(query, searcher, collector, andQuery, false);
    }

    public void searchOverrideSecurity(com.atlassian.query.Query query, User user, Collector collector) throws SearchException {
        this.search(query, user, collector, null, true);
    }

    public void searchAndSort(com.atlassian.query.Query query, User user, Collector collector, PagerFilter pagerFilter) throws SearchException {
        this.searchAndSort(query, user, collector, pagerFilter, false);
    }

    public void searchAndSortOverrideSecurity(com.atlassian.query.Query query, User user, Collector collector, PagerFilter pagerFilter) throws SearchException {
        this.searchAndSort(query, user, collector, pagerFilter, true);
    }

    private long getHitCount(com.atlassian.query.Query searchQuery, User searchUser, SortField[] sortField, Query andQuery, boolean overrideSecurity, IndexSearcher issueSearcher, PagerFilter pager) throws SearchException {
        if (searchQuery == null) {
            return 0L;
        }
        try {
            Filter permissionsFilter = this.getPermissionsFilter(overrideSecurity, searchUser);
            Query finalQuery = this.createLuceneQuery(searchQuery, andQuery, searchUser, overrideSecurity);
            TotalHitCountCollector hitCountCollector = new TotalHitCountCollector();
            issueSearcher.search(finalQuery, permissionsFilter, (Collector)hitCountCollector);
            return hitCountCollector.getTotalHits();
        }
        catch (IOException e) {
            throw new SearchException((Exception)e);
        }
    }

    private TopDocs getHits(com.atlassian.query.Query searchQuery, User searchUser, SortField[] sortField, Query andQuery, boolean overrideSecurity, IndexSearcher issueSearcher, PagerFilter pager) throws SearchException {
        if (searchQuery == null) {
            return null;
        }
        try {
            Filter permissionsFilter = this.getPermissionsFilter(overrideSecurity, searchUser);
            Query finalQuery = this.createLuceneQuery(searchQuery, andQuery, searchUser, overrideSecurity);
            if (log.isDebugEnabled()) {
                log.debug((Object)("JQL sorts: " + Arrays.toString(sortField)));
            }
            return this.runSearch(issueSearcher, finalQuery, permissionsFilter, sortField, searchQuery.toString(), pager);
        }
        catch (IOException e) {
            throw new SearchException((Exception)e);
        }
    }

    private void search(com.atlassian.query.Query searchQuery, User user, Collector collector, Query andQuery, boolean overrideSecurity) throws SearchException {
        long start = System.currentTimeMillis();
        IndexSearcher searcher = this.searchProviderFactory.getSearcher("issues");
        Query finalQuery = andQuery;
        if (searchQuery.getWhereClause() != null) {
            QueryCreationContextImpl context = new QueryCreationContextImpl(user, overrideSecurity);
            Query query = this.luceneQueryBuilder.createLuceneQuery((QueryCreationContext)context, searchQuery.getWhereClause());
            if (query != null) {
                if (finalQuery != null) {
                    BooleanQuery join = new BooleanQuery();
                    join.add(finalQuery, BooleanClause.Occur.MUST);
                    join.add(query, BooleanClause.Occur.MUST);
                    finalQuery = join;
                } else {
                    finalQuery = query;
                }
                log.debug((Object)("JQL query: " + searchQuery.toString()));
                log.debug((Object)("JQL lucene query: " + finalQuery));
            } else {
                log.debug((Object)"Got a null query from the JQL Query.");
            }
        }
        Filter permissionsFilter = this.getPermissionsFilter(overrideSecurity, user);
        UtilTimerStack.push((String)"Searching with Collector");
        if (finalQuery == null) {
            finalQuery = new MatchAllDocsQuery();
        }
        try {
            searcher.search(finalQuery, permissionsFilter, collector);
        }
        catch (IOException e) {
            throw new SearchException("Exception whilst searching for issues " + e.getMessage(), (Exception)e);
        }
        UtilTimerStack.pop((String)"Searching with Collector");
        ThreadLocalQueryProfiler.store("lucene", finalQuery.toString(), System.currentTimeMillis() - start);
    }

    private Query createLuceneQuery(com.atlassian.query.Query searchQuery, Query andQuery, User searchUser, boolean overrideSecurity) throws SearchException {
        String jqlSearchQuery = searchQuery.toString();
        Query finalQuery = andQuery;
        if (searchQuery.getWhereClause() != null) {
            QueryCreationContextImpl context = new QueryCreationContextImpl(searchUser, overrideSecurity);
            Query query = this.luceneQueryBuilder.createLuceneQuery((QueryCreationContext)context, searchQuery.getWhereClause());
            if (query != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JQL query: " + jqlSearchQuery));
                }
                if (finalQuery != null) {
                    BooleanQuery join = new BooleanQuery();
                    join.add(finalQuery, BooleanClause.Occur.MUST);
                    join.add(query, BooleanClause.Occur.MUST);
                    finalQuery = join;
                } else {
                    finalQuery = query;
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Got a null query from the JQL Query.");
            }
        }
        if (finalQuery == null) {
            finalQuery = new MatchAllDocsQuery();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JQL lucene query: " + finalQuery));
        }
        return finalQuery;
    }

    private SearchResults search(com.atlassian.query.Query query, User searcher, PagerFilter pager, Query andQuery, boolean overrideSecurity) throws SearchException {
        long start = System.currentTimeMillis();
        UtilTimerStack.push((String)"Lucene Query");
        IndexSearcher issueSearcher = this.searchProviderFactory.getSearcher("issues");
        TopDocs luceneMatches = this.getHits(query, searcher, this.getSearchSorts(searcher, query), andQuery, overrideSecurity, issueSearcher, pager);
        UtilTimerStack.pop((String)"Lucene Query");
        try {
            List matches;
            int totalIssueCount;
            UtilTimerStack.push((String)"Retrieve From cache/db and filter");
            int n = totalIssueCount = luceneMatches == null ? 0 : luceneMatches.totalHits;
            if (luceneMatches != null && luceneMatches.totalHits >= pager.getStart()) {
                int end = Math.min(pager.getEnd(), luceneMatches.totalHits);
                matches = new ArrayList();
                for (int i = pager.getStart(); i < end; ++i) {
                    Document doc = issueSearcher.doc(luceneMatches.scoreDocs[i].doc);
                    matches.add(this.issueFactory.getIssue(doc));
                }
            } else {
                matches = Collections.emptyList();
            }
            UtilTimerStack.pop((String)"Retrieve From cache/db and filter");
            return new SearchResults(matches, totalIssueCount, pager);
        }
        catch (IOException e) {
            throw new SearchException("Exception whilst searching for issues " + e.getMessage(), (Exception)e);
        }
    }

    private void searchAndSort(com.atlassian.query.Query query, User user, Collector collector, PagerFilter pagerFilter, boolean overrideSecurity) throws SearchException {
        long start = System.currentTimeMillis();
        UtilTimerStack.push((String)"Searching and sorting with Collector");
        try {
            IndexSearcher issueSearcher = this.searchProviderFactory.getSearcher("issues");
            TopDocs hits = this.getHits(query, user, this.getSearchSorts(user, query), null, overrideSecurity, issueSearcher, pagerFilter);
            if (hits != null && hits.totalHits >= pagerFilter.getStart()) {
                int end = Math.min(pagerFilter.getEnd(), hits.totalHits);
                collector.setNextReader(issueSearcher.getIndexReader(), 0);
                for (int i = pagerFilter.getStart(); i < end; ++i) {
                    collector.collect(hits.scoreDocs[i].doc);
                }
            }
        }
        catch (IOException e) {
            throw new SearchException("Exception whilst searching for issues " + e.getMessage(), (Exception)e);
        }
        UtilTimerStack.pop((String)"Searching and sorting with Collector");
        ThreadLocalQueryProfiler.store("lucene", String.valueOf(query), System.currentTimeMillis() - start);
    }

    private CachedWrappedFilterCache getCachedWrappedFilterCache() {
        CachedWrappedFilterCache cache = (CachedWrappedFilterCache)JiraAuthenticationContextImpl.getRequestCache().get("jira.cached.wrapped.filter.cache");
        if (cache == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating new CachedWrappedFilterCache");
            }
            cache = new CachedWrappedFilterCache();
            JiraAuthenticationContextImpl.getRequestCache().put("jira.cached.wrapped.filter.cache", cache);
        }
        return cache;
    }

    private Filter getPermissionsFilter(boolean overRideSecurity, User searchUser) {
        if (!overRideSecurity) {
            CachedWrappedFilterCache cache = this.getCachedWrappedFilterCache();
            Filter filter = cache.getFilter(searchUser);
            if (filter != null) {
                return filter;
            }
            Query permissionQuery = this.permissionsFilterGenerator.getQuery(searchUser);
            filter = new CachingWrapperFilter((Filter)new QueryWrapperFilter(permissionQuery));
            cache.storeFilter(filter, searchUser);
            return filter;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopDocs runSearch(IndexSearcher searcher, Query query, Filter filter, SortField[] sortFields, String searchQueryString, PagerFilter pager) throws IOException {
        Object hits;
        log.debug((Object)("Lucene boolean Query:" + query.toString("")));
        UtilTimerStack.push((String)"Lucene Search");
        OpTimer opTimer = Instrumentation.pullTimer(InstrumentationName.ISSUE_INDEX_READS);
        try {
            int maxHits = pager != null && pager.getEnd() > 0 ? pager.getEnd() : Integer.MAX_VALUE;
            hits = sortFields != null && sortFields.length > 0 ? searcher.search(query, filter, maxHits, new Sort(sortFields)) : searcher.search(query, filter, maxHits);
            long timeQueryTook = opTimer.end().getMillisecondsTaken();
            if (timeQueryTook > 400L && (log.isDebugEnabled() || slowLog.isInfoEnabled())) {
                String msg = String.format("JQL query '%s' produced lucene query '%-1.800s' and took '%d' ms to run.", searchQueryString, query.toString(), timeQueryTook);
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg);
                }
                if (slowLog.isInfoEnabled()) {
                    slowLog.info((Object)msg);
                }
            }
        }
        finally {
            UtilTimerStack.pop((String)"Lucene Search");
        }
        return hits;
    }

    private SortField[] getSearchSorts(User searcher, com.atlassian.query.Query query) {
        if (query == null) {
            return null;
        }
        List sorts = this.searchSortUtil.getSearchSorts(query);
        ArrayList luceneSortFields = new ArrayList();
        if (sorts != null) {
            FieldManager fieldManager = ComponentAccessor.getFieldManager();
            for (SearchSort searchSort : sorts) {
                ArrayList fieldIds = new ArrayList(this.searchHandlerManager.getFieldIds(searcher, searchSort.getField()));
                Collections.sort(fieldIds);
                for (String fieldId : fieldIds) {
                    if (fieldManager.isNavigableField(fieldId)) {
                        NavigableField field = fieldManager.getNavigableField(fieldId);
                        luceneSortFields.addAll(field.getSortFields(this.getSortOrder(searchSort, field)));
                        continue;
                    }
                    log.debug((Object)("Search sort contains invalid field: " + searchSort));
                }
            }
        }
        return luceneSortFields.toArray(new SortField[luceneSortFields.size()]);
    }

    private boolean getSortOrder(SearchSort searchSort, NavigableField field) {
        String defaultSortOrder;
        boolean order = searchSort.getOrder() == null ? ((defaultSortOrder = field.getDefaultSortOrder()) == null ? false : SortOrder.parseString((String)defaultSortOrder) == SortOrder.DESC) : searchSort.isReverse();
        return order;
    }
}

