/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.handlers;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.search.KickassSearchContext;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.impl.TextQuerySearcher;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.DefaultClauseHandler;
import com.atlassian.jira.jql.context.AllTextClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.permission.DefaultClausePermissionHandler;
import com.atlassian.jira.jql.query.AllTextClauseQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.validator.AllTextValidator;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.util.List;

public class TextQuerySearchHandlerFactory
implements SearchHandlerFactory {
    private final ClauseValidator clauseValidator;
    private final ClauseContextFactory clauseContextFactory;
    private JqlOperandResolver operandResolver;
    private KickassSearchContext kickassSearchContext;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ApplicationProperties applicationProperties;
    private final VelocityTemplatingEngine templatingEngine;
    private final ClauseQueryFactory clauseQueryFactory;
    private final ClauseInformation clauseInfo;

    public TextQuerySearchHandlerFactory(AllTextValidator clauseValidator, AllTextClauseContextFactory clauseContextFactory, CustomFieldManager customFieldManager, SearchHandlerManager searchHandlerManager, JqlOperandResolver operandResolver, KickassSearchContext kickassSearchContext, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine) {
        this.operandResolver = operandResolver;
        this.kickassSearchContext = kickassSearchContext;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.applicationProperties = applicationProperties;
        this.templatingEngine = templatingEngine;
        this.clauseContextFactory = (ClauseContextFactory)Assertions.notNull((String)"clauseContextFactory", (Object)clauseContextFactory);
        this.clauseQueryFactory = new AllTextClauseQueryFactory(customFieldManager, searchHandlerManager);
        this.clauseInfo = SystemSearchConstants.forAllText();
        this.clauseValidator = (ClauseValidator)Assertions.notNull((String)"clauseValidator", (Object)clauseValidator);
    }

    @Override
    public SearchHandler createHandler(SearchableField field) {
        return this.createHandler();
    }

    public SearchHandler createHandler() {
        TextQuerySearcher searcher = new TextQuerySearcher(this.operandResolver, this.velocityRequestContextFactory, this.applicationProperties, this.templatingEngine, this.kickassSearchContext);
        DefaultClauseHandler clauseHandler = new DefaultClauseHandler(this.clauseInfo, this.clauseQueryFactory, this.clauseValidator, DefaultClausePermissionHandler.NOOP_CLAUSE_PERMISSION_HANDLER, this.clauseContextFactory);
        SearchHandler.SearcherRegistration searcherRegistration = new SearchHandler.SearcherRegistration((IssueSearcher)searcher, (ClauseHandler)clauseHandler);
        List relatedIndexers = searcher.getSearchInformation().getRelatedIndexers();
        return new SearchHandler(relatedIndexers, searcherRegistration);
    }
}

