/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.AbstractLanguageAnalyser;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.br.BrazilianStemFilter;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.util.Version;

public class BrazilianAnalyzer
extends AbstractLanguageAnalyser {
    private final Set<?> stopWords;
    private final Version matchVersion;

    public BrazilianAnalyzer(Version matchVersion, boolean indexing) {
        super(indexing);
        this.matchVersion = matchVersion;
        this.stopWords = org.apache.lucene.analysis.br.BrazilianAnalyzer.getDefaultStopSet();
    }

    public final TokenStream tokenStream(String fieldname, Reader reader) {
        ClassicTokenizer result = new ClassicTokenizer(this.matchVersion, reader);
        result = new StandardFilter(this.matchVersion, (TokenStream)result);
        result = this.wrapStreamForIndexing((TokenStream)result);
        result = new LowerCaseFilter(this.matchVersion, (TokenStream)result);
        result = new StopFilter(this.matchVersion, (TokenStream)result, this.stopWords);
        result = new BrazilianStemFilter((TokenStream)result);
        return result;
    }
}

