/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.util.Supplier;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;

class SearcherCache {
    private static final ThreadLocal<SearcherCache> THREAD_LOCAL = new ThreadLocal();
    private IndexSearcher issueSearcher;
    private IndexSearcher commentSearcher;
    private IndexSearcher changeSearcher;

    static SearcherCache getThreadLocalCache() {
        SearcherCache threadLocalSearcherCache = THREAD_LOCAL.get();
        if (threadLocalSearcherCache == null) {
            threadLocalSearcherCache = new SearcherCache();
            THREAD_LOCAL.set(threadLocalSearcherCache);
        }
        return threadLocalSearcherCache;
    }

    IndexSearcher retrieveIssueSearcher(Supplier<IndexSearcher> searcherSupplier) {
        if (this.issueSearcher == null) {
            this.issueSearcher = (IndexSearcher)searcherSupplier.get();
        }
        return this.issueSearcher;
    }

    IndexReader retrieveIssueReader(Supplier<IndexSearcher> searcherSupplier) {
        return this.retrieveIssueSearcher(searcherSupplier).getIndexReader();
    }

    IndexSearcher retrieveCommentSearcher(Supplier<IndexSearcher> searcherSupplier) {
        if (this.commentSearcher == null) {
            this.commentSearcher = (IndexSearcher)searcherSupplier.get();
        }
        return this.commentSearcher;
    }

    IndexSearcher retrieveChangeHistorySearcher(Supplier<IndexSearcher> searcherSupplier) {
        if (this.changeSearcher == null) {
            this.changeSearcher = (IndexSearcher)searcherSupplier.get();
        }
        return this.changeSearcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSearchers() throws IOException {
        try {
            this.closeSearcher(this.issueSearcher);
        }
        finally {
            this.issueSearcher = null;
            try {
                this.closeSearcher(this.commentSearcher);
            }
            finally {
                this.commentSearcher = null;
                try {
                    this.closeSearcher(this.changeSearcher);
                }
                finally {
                    this.changeSearcher = null;
                }
            }
        }
    }

    private void closeSearcher(IndexSearcher searcher) throws IOException {
        if (searcher != null) {
            searcher.close();
        }
    }

    private SearcherCache() {
    }
}

