/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.external;

import com.atlassian.instrumentation.CachedExternalValue;
import com.atlassian.instrumentation.ExternalCounter;
import com.atlassian.instrumentation.ExternalGauge;
import com.atlassian.instrumentation.ExternalValue;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.instrumentation.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.TimeUnit;

class ThreadExternalGauges {
    ThreadExternalGauges() {
        Instrumentation.putInstrument((Instrument)new ExternalGauge("jmx.thread.total.count", (ExternalValue)new ThreadMXExternalValue(){

            public long getValue() {
                return this.getMxBean().getThreadCount();
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalGauge("jmx.thread.daemon.count", (ExternalValue)new ThreadMXExternalValue(){

            public long getValue() {
                return this.getMxBean().getDaemonThreadCount();
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalGauge("jmx.thread.nondaemon.count", (ExternalValue)new ThreadMXExternalValue(){

            public long getValue() {
                ThreadMXBean threadMXBean = this.getMxBean();
                return threadMXBean.getThreadCount() - threadMXBean.getDaemonThreadCount();
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalGauge("jmx.thread.peak.count", (ExternalValue)new ThreadMXExternalValue(){

            public long getValue() {
                return this.getMxBean().getPeakThreadCount();
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalGauge("jmx.thread.ever.count", (ExternalValue)new ThreadMXExternalValue(){

            public long getValue() {
                return this.getMxBean().getTotalStartedThreadCount();
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalCounter("jmx.thread.cpu.time", (ExternalValue)new CachedThreadMXExternalValue(){

            protected long computeValue() {
                return this.safelyGetValue(new CachedThreadMXExternalValue.CalculateThreadValue(){

                    @Override
                    public long calculate(long threadId, ThreadMXBean mxBean) {
                        return mxBean.getThreadCpuTime(threadId);
                    }
                });
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalCounter("jmx.thread.cpu.user.time", (ExternalValue)new CachedThreadMXExternalValue(){

            protected long computeValue() {
                return this.safelyGetValue(new CachedThreadMXExternalValue.CalculateThreadValue(){

                    @Override
                    public long calculate(long threadId, ThreadMXBean mxBean) {
                        return mxBean.getThreadUserTime(threadId);
                    }
                });
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalCounter("jmx.thread.cpu.block.time", (ExternalValue)new CachedThreadMXExternalValue(){

            protected long computeValue() {
                if (this.isThreadContentionAvailable()) {
                    return this.safelyGetValue(new CachedThreadMXExternalValue.CalculateThreadValue(){

                        @Override
                        public long calculate(long threadId, ThreadMXBean mxBean) {
                            return mxBean.getThreadInfo(threadId).getBlockedTime();
                        }
                    });
                }
                return 0L;
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalCounter("jmx.thread.cpu.block.count", (ExternalValue)new CachedThreadMXExternalValue(){

            protected long computeValue() {
                if (this.isThreadContentionAvailable()) {
                    return this.safelyGetValue(new CachedThreadMXExternalValue.CalculateThreadValue(){

                        @Override
                        public long calculate(long threadId, ThreadMXBean mxBean) {
                            return mxBean.getThreadInfo(threadId).getBlockedCount();
                        }
                    });
                }
                return 0L;
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalCounter("jmx.thread.cpu.wait.time", (ExternalValue)new CachedThreadMXExternalValue(){

            protected long computeValue() {
                if (this.isThreadContentionAvailable()) {
                    return this.safelyGetValue(new CachedThreadMXExternalValue.CalculateThreadValue(){

                        @Override
                        public long calculate(long threadId, ThreadMXBean mxBean) {
                            return mxBean.getThreadInfo(threadId).getWaitedTime();
                        }
                    });
                }
                return 0L;
            }
        }));
        Instrumentation.putInstrument((Instrument)new ExternalCounter("jmx.thread.cpu.wait.count", (ExternalValue)new CachedThreadMXExternalValue(){

            protected long computeValue() {
                if (this.isThreadContentionAvailable()) {
                    return this.safelyGetValue(new CachedThreadMXExternalValue.CalculateThreadValue(){

                        @Override
                        public long calculate(long threadId, ThreadMXBean mxBean) {
                            return mxBean.getThreadInfo(threadId).getWaitedCount();
                        }
                    });
                }
                return 0L;
            }
        }));
    }

    private static abstract class CachedThreadMXExternalValue
    extends CachedExternalValue {
        protected CachedThreadMXExternalValue() {
            super(2L, TimeUnit.MINUTES);
        }

        ThreadMXBean getMxBean() {
            return ManagementFactory.getThreadMXBean();
        }

        long safelyGetValue(CalculateThreadValue calculateThreadValue) {
            try {
                long value = 0L;
                for (long threadId : this.getMxBean().getAllThreadIds()) {
                    value += calculateThreadValue.calculate(threadId, this.getMxBean());
                }
                return Math.max(0L, value);
            }
            catch (Exception e) {
                return 0L;
            }
        }

        boolean isThreadContentionAvailable() {
            return this.getMxBean().isThreadContentionMonitoringSupported() && this.getMxBean().isThreadContentionMonitoringEnabled();
        }

        static interface CalculateThreadValue {
            public long calculate(long var1, ThreadMXBean var3);
        }
    }

    private static abstract class ThreadMXExternalValue
    implements ExternalValue {
        private ThreadMXExternalValue() {
        }

        ThreadMXBean getMxBean() {
            return ManagementFactory.getThreadMXBean();
        }
    }
}

