/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.validation;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.mapper.IssueTypeMapper;
import com.atlassian.jira.imports.project.mapper.StatusMapper;
import com.atlassian.jira.imports.project.validation.StatusMapperValidator;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ListOrderedMessageSetImpl;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import java.util.Collection;
import org.apache.log4j.Logger;

public class StatusMapperValidatorImpl
implements StatusMapperValidator {
    private static final Logger log = Logger.getLogger(StatusMapperValidatorImpl.class);
    private final ProjectManager projectManager;
    private final ConstantsManager constantsManager;
    private final WorkflowManager workflowManager;

    public StatusMapperValidatorImpl(ProjectManager projectManager, ConstantsManager constantsManager, WorkflowManager workflowManager) {
        this.projectManager = projectManager;
        this.constantsManager = constantsManager;
        this.workflowManager = workflowManager;
    }

    @Override
    public MessageSet validateMappings(I18nHelper i18nHelper, BackupProject backupProject, IssueTypeMapper issueTypeMapper, StatusMapper statusMapper) {
        String projectKey = backupProject.getProject().getKey();
        ListOrderedMessageSetImpl messageSet = new ListOrderedMessageSetImpl();
        for (String oldId : statusMapper.getRequiredOldIds()) {
            String newId = statusMapper.getMappedId(oldId);
            if (newId == null) {
                String statusName = statusMapper.getKey(oldId);
                if (statusName == null) {
                    messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.status.validation.status.not.registered", oldId));
                    messageSet.addErrorMessageInEnglish("The status with ID '" + oldId + "' is required for the import but could not find this Status configured in the import.");
                    continue;
                }
                Status existingStatus = this.constantsManager.getStatusByName(statusName);
                if (existingStatus == null) {
                    messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.status.validation.does.not.exist", statusMapper.getDisplayName(oldId)));
                    messageSet.addErrorMessageInEnglish("The status '" + statusMapper.getDisplayName(oldId) + "' is required for the import but does not exist in the current JIRA instance.");
                }
                if (!this.validateStatus(oldId, existingStatus, statusMapper, issueTypeMapper, projectKey, (MessageSet)messageSet, i18nHelper)) continue;
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.status.validation.required.not.mapped", statusMapper.getDisplayName(oldId)));
                messageSet.addErrorMessageInEnglish("The status '" + statusMapper.getDisplayName(oldId) + "' is required for the import but was not mapped.");
                continue;
            }
            Status existingStatus = this.constantsManager.getStatusObject(newId);
            this.validateStatus(oldId, existingStatus, statusMapper, issueTypeMapper, projectKey, (MessageSet)messageSet, i18nHelper);
        }
        return messageSet;
    }

    @Override
    public boolean isStatusValid(String oldStatusId, Status existingStatus, StatusMapper statusMapper, IssueTypeMapper issueTypeMapper, String projectKey) {
        return this.validateStatus(oldStatusId, existingStatus, statusMapper, issueTypeMapper, projectKey, null, null);
    }

    private boolean validateStatus(String oldStatusId, Status existingStatus, StatusMapper statusMapper, IssueTypeMapper issueTypeMapper, String projectKey, MessageSet messageSet, I18nHelper i18nHelper) {
        Project existingProject = this.projectManager.getProjectObjByKey(projectKey);
        boolean valid = true;
        Collection requiredStatus = statusMapper.getIssueTypeIdsForRequiredStatus(oldStatusId);
        if (requiredStatus != null) {
            for (String issueTypeId : requiredStatus) {
                String errorMessage;
                JiraWorkflow workflow = existingProject == null ? this.workflowManager.getDefaultWorkflow() : this.workflowManager.getWorkflow(existingProject.getId(), issueTypeMapper.getMappedId(issueTypeId));
                if (workflow.getLinkedStatusObjects().contains(existingStatus)) continue;
                valid = false;
                if (messageSet == null) continue;
                String statusDisplayName = statusMapper.getDisplayName(oldStatusId);
                String issueTypeDisplayName = issueTypeMapper.getDisplayName(issueTypeId);
                String workflowName = workflow.getName();
                MessageSet.MessageLink link = this.getMessageLink("setupworkflowissuegroup", i18nHelper);
                if (existingProject != null) {
                    if (this.isUsingDefaultWorkflow(workflow)) {
                        errorMessage = i18nHelper.getText("admin.errors.project.import.status.validation.enterprise.existing.project.default.workflow.not.in.workflow", statusDisplayName, issueTypeDisplayName, workflowName);
                        messageSet.addErrorMessage(errorMessage, link);
                        messageSet.addErrorMessageInEnglish("The status '" + statusDisplayName + "' is in use by an issue of type '" + issueTypeDisplayName + "' in the backup file. The default workflow '" + workflowName + "', which is associated with issue type ''{1}'', does not use this status. This workflow is not editable. You must associate a workflow with issue type '" + issueTypeDisplayName + "' that uses the status. To do this you will need to use a workflow scheme.");
                        continue;
                    }
                    errorMessage = i18nHelper.getText("admin.errors.project.import.status.validation.enterprise.existing.project.custom.workflow.not.in.workflow", statusDisplayName, issueTypeDisplayName, workflowName);
                    messageSet.addErrorMessage(errorMessage, link);
                    messageSet.addErrorMessageInEnglish("The status '" + statusDisplayName + "' is in use by an issue of type '" + issueTypeDisplayName + "' in the backup file. The workflow '" + workflowName + "', which is associated with issue type '" + issueTypeDisplayName + "', does not use this status. You must either edit the workflow to use the status or associate a workflow with issue type '" + issueTypeDisplayName + "' that uses the status.");
                    continue;
                }
                errorMessage = i18nHelper.getText("admin.errors.project.import.status.validation.enterprise.no.existing.project.default.workflow.not.in.workflow", statusDisplayName, issueTypeDisplayName, workflowName, projectKey);
                messageSet.addErrorMessage(errorMessage, link);
                messageSet.addErrorMessageInEnglish("The status '" + statusDisplayName + "' is in use by an issue of type '" + issueTypeDisplayName + "' in the backup file. The default workflow '" + workflowName + "', which is associated with issue type '" + issueTypeDisplayName + "', does not use this status. This workflow is not editable. You must create a project with key '" + projectKey + "', instead of letting the import create it for you, and associate a workflow with issue type '" + issueTypeDisplayName + "' that uses the status. To do this you will need to use a workflow scheme.");
            }
        }
        return valid;
    }

    MessageSet.MessageLink getMessageLink(String helpPathProperty, I18nHelper i18n) {
        HelpUtil.HelpPath helpPath = HelpUtil.getInstance().getHelpPath(helpPathProperty);
        return new MessageSet.MessageLink(i18n.getText("admin.errors.project.import.status.validation.doc.link.text"), helpPath.getUrl(), true);
    }

    boolean isUsingDefaultWorkflow(JiraWorkflow workflow) {
        JiraWorkflow defaultWorkflow = this.workflowManager.getDefaultWorkflow();
        return defaultWorkflow.equals(workflow);
    }
}

