/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.validation;

import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.mapper.IssueLinkTypeMapper;
import com.atlassian.jira.imports.project.validation.IssueLinkTypeMapperValidator;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import java.util.Collection;
import org.apache.log4j.Logger;

public class IssueLinkTypeMapperValidatorImpl
implements IssueLinkTypeMapperValidator {
    private static final Logger log = Logger.getLogger(IssueLinkTypeMapperValidatorImpl.class);
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final SubTaskManager subTaskManager;
    private final ApplicationProperties applicationProperties;

    public IssueLinkTypeMapperValidatorImpl(IssueLinkTypeManager issueLinkTypeManager, SubTaskManager subTaskManager, ApplicationProperties applicationProperties) {
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.subTaskManager = subTaskManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public MessageSet validateMappings(I18nHelper i18nHelper, BackupProject backupProject, IssueLinkTypeMapper issueLinkTypeMapper) {
        MessageSetImpl messageSet = new MessageSetImpl();
        if (issueLinkTypeMapper.getRegisteredOldIds().isEmpty()) {
            return messageSet;
        }
        if (!this.isIssueLinkingEnabled()) {
            messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issuelinktype.disabled"));
            messageSet.addErrorMessageInEnglish("Issue Linking must be enabled because there are issue links in the project to import.");
        }
        for (String oldId : issueLinkTypeMapper.getRequiredOldIds()) {
            String newId = issueLinkTypeMapper.getMappedId(oldId);
            if (newId == null) {
                String issueLinkTypeName = issueLinkTypeMapper.getKey(oldId);
                IssueLinkType issueLinkType = this.getIssueLinkTypeByName(issueLinkTypeName);
                if (issueLinkType == null) {
                    messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issuelinktype.type.does.not.exist", issueLinkTypeName));
                    messageSet.addErrorMessageInEnglish("The Issue Link Type '" + issueLinkTypeName + "' is required for the import but does not exist in the current JIRA instance.");
                    continue;
                }
                this.validateStyle(oldId, issueLinkType, issueLinkTypeMapper, (MessageSet)messageSet, i18nHelper);
                if (messageSet.hasAnyErrors()) continue;
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issuelinktype.no.mapping", issueLinkTypeName));
                messageSet.addErrorMessageInEnglish("The Issue Link Type '" + issueLinkTypeName + "' is required for the import but has not been mapped.");
                continue;
            }
            IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(new Long(newId));
            if (issueLinkType == null) {
                String issueLinkTypeName = issueLinkTypeMapper.getKey(oldId);
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issuelinktype.mapped.type.does.not.exist", issueLinkTypeName, newId));
                messageSet.addErrorMessageInEnglish("The Issue Link Type '" + issueLinkTypeName + "' was mapped to an IssuelinkType ID (" + newId + ") that does not exist.");
                continue;
            }
            this.validateStyle(oldId, issueLinkType, issueLinkTypeMapper, (MessageSet)messageSet, i18nHelper);
        }
        return messageSet;
    }

    private boolean isIssueLinkingEnabled() {
        return this.applicationProperties.getOption("jira.option.issuelinking");
    }

    private void validateStyle(String oldId, IssueLinkType issueLinkType, IssueLinkTypeMapper issueLinkTypeMapper, MessageSet messageSet, I18nHelper i18nHelper) {
        String oldStyle = issueLinkTypeMapper.getStyle(oldId);
        String newStyle = issueLinkType.getStyle();
        String issueLinkTypeName = issueLinkTypeMapper.getKey(oldId);
        if (oldStyle == null) {
            if (newStyle != null) {
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issuelinktype.style.in.new.type.only", issueLinkTypeName, newStyle));
                messageSet.addErrorMessageInEnglish("The Issue Link Type '" + issueLinkTypeName + "' has no style value in the backup, but has style '" + newStyle + "' in the current system.");
            }
        } else {
            if (oldStyle.equals("jira_subtask") && !this.subTaskManager.isSubTasksEnabled()) {
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issuelinktype.subtasks.disabled"));
                messageSet.addErrorMessageInEnglish("The project to import includes subtasks, but subtasks are disabled in the current system.");
            }
            if (newStyle == null) {
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issuelinktype.style.in.old.type.only", issueLinkTypeName, oldStyle));
                messageSet.addErrorMessageInEnglish("The Issue Link Type '" + issueLinkTypeName + "' has style '" + oldStyle + "' in the backup, but has no style in the current system.");
            } else if (!oldStyle.equals(newStyle)) {
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.issuelinktype.different.styles", issueLinkTypeName, oldStyle, newStyle));
                messageSet.addErrorMessageInEnglish("The Issue Link Type '" + issueLinkTypeName + "' has style '" + oldStyle + "' in the backup, but has style '" + newStyle + "' in the current system.");
            }
        }
    }

    private IssueLinkType getIssueLinkTypeByName(String linkTypeName) {
        Collection linkTypes = this.issueLinkTypeManager.getIssueLinkTypesByName(linkTypeName);
        if (linkTypes.isEmpty()) {
            return null;
        }
        return (IssueLinkType)linkTypes.iterator().next();
    }
}

