/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.taskprogress;

import com.atlassian.jira.task.TaskProgressSink;

public class TaskProgressInterval {
    final int startPercent;
    final int endPercent;
    final TaskProgressSink taskProgressSink;

    public TaskProgressInterval(TaskProgressSink taskProgressSink, int startPercent, int endPercent) {
        this.taskProgressSink = taskProgressSink;
        this.startPercent = startPercent;
        this.endPercent = endPercent;
    }

    public TaskProgressInterval getSubInterval(int subIntervalStartPercent, int subIntervalEndPercent) {
        int parentIntervalLength = this.endPercent - this.startPercent;
        int overallStartPercent = this.getStartPercent() + subIntervalStartPercent * parentIntervalLength / 100;
        int overallEndPercent = this.getStartPercent() + subIntervalEndPercent * parentIntervalLength / 100;
        return new TaskProgressInterval(this.taskProgressSink, overallStartPercent, overallEndPercent);
    }

    public int getStartPercent() {
        return this.startPercent;
    }

    public int getEndPercent() {
        return this.endPercent;
    }

    public TaskProgressSink getTaskProgressSink() {
        return this.taskProgressSink;
    }
}

