/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.image.util;

import com.atlassian.jira.image.util.ImageUtils;
import java.awt.Color;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ImageUtilsImpl
implements ImageUtils {
    private static final Logger log = Logger.getLogger(ImageUtilsImpl.class);

    public Color getColor(String hexString, boolean transparent) {
        if (StringUtils.isNotBlank((String)hexString)) {
            try {
                if (hexString.startsWith("#")) {
                    hexString = hexString.substring(1, hexString.length());
                }
                if (hexString.length() == 3) {
                    String s = hexString.substring(0, 1);
                    int r = Integer.parseInt(s + s, 16);
                    s = hexString.substring(1, 2);
                    int g = Integer.parseInt(s + s, 16);
                    s = hexString.substring(2, 3);
                    int b = Integer.parseInt(s + s, 16);
                    int a = transparent ? 0 : 255;
                    return new Color(r, g, b, a);
                }
                if (hexString.length() == 6) {
                    int r = Integer.parseInt(hexString.substring(0, 2), 16);
                    int g = Integer.parseInt(hexString.substring(2, 4), 16);
                    int b = Integer.parseInt(hexString.substring(4, 6), 16);
                    int a = transparent ? 0 : 255;
                    return new Color(r, g, b, a);
                }
                log.warn((Object)("Color must be a 6 or 3 char hex string (with an optional leading hash) but was " + hexString));
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)"Color must be a 6 or 3 char hex string (with an optional leading hash)", (Throwable)nfe);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                log.warn((Object)"Color must be a 6 or 3 char hex string (with an optional leading hash)", (Throwable)e);
            }
            catch (StringIndexOutOfBoundsException e) {
                log.warn((Object)"Color must be a 6 or 3 char hex string (with an optional leading hash)", (Throwable)e);
            }
        }
        return null;
    }
}

