/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity;

import com.atlassian.jira.entity.EntityBuilder;
import com.atlassian.jira.entity.EntityBuilders;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.NamedEntityBuilder;
import com.atlassian.jira.entity.SelectQuery;
import com.atlassian.jira.entity.SelectQueryImpl;
import com.atlassian.jira.entity.StringEntityBuilder;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class Select {
    public static SelectColumnsContext columns(String ... columns) {
        return new SelectColumnsContext(columns, false);
    }

    public static SelectColumnsContext distinct(String ... columns) {
        return new SelectColumnsContext(columns, true);
    }

    public static SelectSingleColumnContext<String> distinctString(String columnName) {
        StringEntityBuilder entityBuilder = new StringEntityBuilder(columnName);
        return new SelectSingleColumnContext<String>(columnName, true, entityBuilder);
    }

    public static <E> SelectColumnsFromContext<E> from(NamedEntityBuilder<E> entityFactory) {
        QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.fieldsToSelect = null;
        queryBuilder.distinct = false;
        queryBuilder.entityBuilder = entityFactory;
        queryBuilder.entityName = entityFactory.getEntityName();
        return new SelectColumnsFromContext(queryBuilder);
    }

    private static class QueryBuilder<E> {
        private boolean distinct;
        private Collection<String> fieldsToSelect;
        private String entityName;
        private FieldMap whereClause;
        private List<String> orderBy;
        public EntityBuilder<E> entityBuilder;

        private QueryBuilder() {
        }

        public SelectQuery<E> toQuery() {
            return new SelectQueryImpl<E>(this.distinct, this.fieldsToSelect, this.entityName, this.entityBuilder, this.whereClause, this.orderBy);
        }
    }

    public static class OrderByContext<E>
    implements SelectQuery<E> {
        private final QueryBuilder<E> queryBuilder;

        private OrderByContext(QueryBuilder<E> queryBuilder) {
            this.queryBuilder = queryBuilder;
        }

        @Override
        public SelectQuery.ExecutionContext<E> runWith(OfBizDelegator ofBizDelegator) {
            return this.queryBuilder.toQuery().runWith(ofBizDelegator);
        }

        @Override
        public SelectQuery.ExecutionContext<E> runWith(EntityEngine entityEngine) {
            return this.queryBuilder.toQuery().runWith(entityEngine);
        }
    }

    public static class WhereContext<E>
    implements SelectQuery<E> {
        private final QueryBuilder<E> queryBuilder;

        private WhereContext(QueryBuilder<E> queryBuilder) {
            this.queryBuilder = queryBuilder;
        }

        public WhereContext andEqual(String fieldName, String value) {
            ((QueryBuilder)this.queryBuilder).whereClause.add(fieldName, (Object)value);
            return this;
        }

        public WhereContext andEqual(String fieldName, Long value) {
            ((QueryBuilder)this.queryBuilder).whereClause.add(fieldName, (Object)value);
            return this;
        }

        public OrderByContext<E> orderBy(String ... orderByColumn) {
            ((QueryBuilder)this.queryBuilder).orderBy = Arrays.asList(orderByColumn);
            return new OrderByContext(this.queryBuilder);
        }

        @Override
        public SelectQuery.ExecutionContext<E> runWith(OfBizDelegator ofBizDelegator) {
            return this.queryBuilder.toQuery().runWith(ofBizDelegator);
        }

        @Override
        public SelectQuery.ExecutionContext<E> runWith(EntityEngine entityEngine) {
            return this.queryBuilder.toQuery().runWith(entityEngine);
        }
    }

    public static class SelectColumnsFromContext<E>
    implements SelectQuery<E> {
        private final QueryBuilder<E> queryBuilder;

        private SelectColumnsFromContext(QueryBuilder<E> queryBuilder) {
            this.queryBuilder = queryBuilder;
        }

        public WhereContext<E> whereEqual(String fieldName, String value) {
            ((QueryBuilder)this.queryBuilder).whereClause = new FieldMap(fieldName, (Object)value);
            return new WhereContext(this.queryBuilder);
        }

        public WhereContext<E> whereEqual(String fieldName, Long value) {
            ((QueryBuilder)this.queryBuilder).whereClause = new FieldMap(fieldName, (Object)value);
            return new WhereContext(this.queryBuilder);
        }

        @Override
        public SelectQuery.ExecutionContext<E> runWith(OfBizDelegator ofBizDelegator) {
            return this.queryBuilder.toQuery().runWith(ofBizDelegator);
        }

        @Override
        public SelectQuery.ExecutionContext<E> runWith(EntityEngine entityEngine) {
            return this.queryBuilder.toQuery().runWith(entityEngine);
        }
    }

    public static class SelectColumnsContext {
        private final QueryBuilder<GenericValue> queryBuilder = new QueryBuilder();

        private SelectColumnsContext(String[] columns, boolean distinct) {
            ((QueryBuilder)this.queryBuilder).fieldsToSelect = Arrays.asList(columns);
            ((QueryBuilder)this.queryBuilder).distinct = distinct;
        }

        public SelectColumnsFromContext<GenericValue> from(String entityName) {
            ((QueryBuilder)this.queryBuilder).entityName = entityName;
            this.queryBuilder.entityBuilder = EntityBuilders.NO_OP_BUILDER;
            return new SelectColumnsFromContext<GenericValue>(this.queryBuilder);
        }
    }

    public static class SelectSingleColumnContext<E> {
        private final QueryBuilder<E> queryBuilder = new QueryBuilder();

        private SelectSingleColumnContext(String columnName, boolean distinct, EntityBuilder<E> entityBuilder) {
            ((QueryBuilder)this.queryBuilder).fieldsToSelect = Collections.singletonList(columnName);
            ((QueryBuilder)this.queryBuilder).distinct = distinct;
            this.queryBuilder.entityBuilder = entityBuilder;
        }

        public SelectColumnsFromContext<E> from(String entityName) {
            ((QueryBuilder)this.queryBuilder).entityName = entityName;
            return new SelectColumnsFromContext(this.queryBuilder);
        }
    }
}

