/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.diagnostic;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.web.monitor.dump.Dumper;
import com.atlassian.plugin.IllegalPluginStateException;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginContainerFailedEvent;
import com.atlassian.plugin.osgi.event.PluginServiceDependencyWaitTimedOutEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDiagnostics {
    private static final Logger log = LoggerFactory.getLogger(PluginDiagnostics.class);

    public PluginDiagnostics(PluginEventManager pluginEventManager) {
        if (JiraSystemProperties.isDevMode() || Boolean.getBoolean("jira.dump")) {
            log.warn("Registering PluginDiagnostics with the event manager.");
            pluginEventManager.register((Object)new DiagnosticListener());
        }
    }

    public static class DiagnosticListener {
        private final AtomicBoolean dumped = new AtomicBoolean();

        @PluginEventListener
        public void onSpringContextFailed(PluginContainerFailedEvent event) throws IllegalPluginStateException {
            this.dump(String.format("Plugin %s failed", event.getPluginKey()));
        }

        @PluginEventListener
        public void onDependencyTimedOut(PluginServiceDependencyWaitTimedOutEvent timedOutEvent) {
            this.dump(String.format("Service dependency in plugin %s on %s timed out after %d", timedOutEvent.getPluginKey(), timedOutEvent.getBeanName(), timedOutEvent.getElapsedTime()));
        }

        private void dump(String reason) {
            if (this.dumped.compareAndSet(false, true)) {
                log.warn("Creating a thread dump because {}", (Object)reason);
                new Dumper().dumpThreads(null);
            }
        }
    }
}

