/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.webwork;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import webwork.config.ConfigurationInterface;
import webwork.config.WebworkConfigurationNotFoundException;

public class ApplicationPropertiesConfiguration
implements ConfigurationInterface {
    private static Set<String> WHITELIST_OF_KEYS = new HashSet<String>();

    public Object getImpl(String aName) throws IllegalArgumentException {
        String setting = null;
        if (WHITELIST_OF_KEYS.contains(aName)) {
            setting = this.getApplicationProperties().getDefaultBackedString(aName);
        }
        if (setting == null) {
            throw new WebworkConfigurationNotFoundException(this.getClass(), "No such setting", aName);
        }
        return setting;
    }

    ApplicationProperties getApplicationProperties() {
        return ComponentManager.getComponent(ApplicationProperties.class);
    }

    public void setImpl(String aName, Object aValue) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot set Application Properties through this interface");
    }

    public Iterator listImpl() {
        return this.getApplicationProperties().getKeys().iterator();
    }

    static {
        WHITELIST_OF_KEYS.add("webwork.multipart.maxSize");
        WHITELIST_OF_KEYS.add("webwork.i18n.encoding");
    }
}

