/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bulkedit.operation.AbstractBulkOperation;
import com.atlassian.jira.bulkedit.operation.BulkOperation;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.bean.BulkEditBean;
import java.util.List;
import org.apache.log4j.Logger;

public class BulkDeleteOperation
extends AbstractBulkOperation
implements BulkOperation {
    protected static final Logger log = Logger.getLogger(BulkDeleteOperation.class);
    public static final String NAME = "BulkDelete";
    public static final String NAME_KEY = "bulk.delete.operation.name";
    private static final String DESCRIPTION_KEY = "bulk.delete.operation.description";
    private static final String CANNOT_PERFORM_MESSAGE_KEY = "bulk.delete.cannotperform";

    public boolean canPerform(BulkEditBean bulkEditBean, User remoteUser) {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        PermissionManager permissionManager = ComponentAccessor.getPermissionManager();
        for (Issue issue : selectedIssues) {
            if (permissionManager.hasPermission(16, issue, remoteUser)) continue;
            return false;
        }
        return true;
    }

    public void perform(BulkEditBean bulkEditBean, User remoteUser) throws RemoveException {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        IssueManager issueManager = ComponentAccessor.getIssueManager();
        boolean sendMail = bulkEditBean.isSendBulkNotification();
        for (Issue issue : selectedIssues) {
            if (issueManager.getIssueObject(issue.getId()) != null) {
                issueManager.deleteIssue(remoteUser, issue, EventDispatchOption.ISSUE_DELETED, sendMail);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Not deleting issue with id '" + issue.getId() + "' and key '" + issue.getKey() + "' as it does not exist in the database (it could have been deleted earlier as it might be a subtask)."));
        }
    }

    public String getNameKey() {
        return NAME_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof BulkDeleteOperation;
    }

    public String getOperationName() {
        return NAME;
    }

    public String getCannotPerformMessageKey() {
        return CANNOT_PERFORM_MESSAGE_KEY;
    }
}

