/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.watcher;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.user.preferences.UserPreferencesManager;

public class AutoWatchService
implements Startable {
    private final EventPublisher eventPublisher;
    private final WatcherService watcherService;
    private final UserPreferencesManager userPreferencesManager;

    public AutoWatchService(EventPublisher eventPublisher, WatcherService watcherService, UserPreferencesManager userPreferencesManager) {
        this.eventPublisher = eventPublisher;
        this.watcherService = watcherService;
        this.userPreferencesManager = userPreferencesManager;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onIssueEvent(IssueEvent event) {
        User user;
        if (this.watcherService.isWatchingEnabled() && (user = event.getUser()) != null && this.isEnabled(user) && this.isAutowatchEvent(event)) {
            this.watcherService.addWatcher(event.getIssue(), user, user);
        }
    }

    private boolean isAutowatchEvent(IssueEvent event) {
        Long eventTypeId = event.getEventTypeId();
        boolean createOrComment = eventTypeId != null && (eventTypeId.equals(EventType.ISSUE_CREATED_ID) || eventTypeId.equals(EventType.ISSUE_COMMENTED_ID));
        return createOrComment || event.getComment() != null;
    }

    private boolean isEnabled(User user) {
        return !this.userPreferencesManager.getPreferences(user).getBoolean("user.autowatch.disabled");
    }
}

