/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.appconsistency.integrity.check.CheckAmendment;
import com.atlassian.jira.appconsistency.integrity.check.CheckImpl;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class FieldLayoutCheck
extends CheckImpl {
    private static final String CUSTOM_FIELD_STRING = "customfield";
    private FieldManager fieldManager = ComponentManager.getInstance().getFieldManager();

    public FieldLayoutCheck(OfBizDelegator ofBizDelegator, int id) {
        super(ofBizDelegator, id);
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.field.layout.check.desc");
    }

    @Override
    public List preview() throws IntegrityException {
        return this.doCheck(false);
    }

    @Override
    public List correct() throws IntegrityException {
        return this.doCheck(true);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getUnavailableMessage() {
        return "";
    }

    private List doCheck(boolean correct) throws IntegrityException {
        ArrayList<CheckAmendment> results = new ArrayList<CheckAmendment>();
        HashSet<String> fieldsToRemove = new HashSet<String>();
        try {
            String message;
            List fieldLayoutItems = this.ofBizDelegator.findAll("FieldLayoutItem");
            for (GenericValue fieldLayoutItemGV : fieldLayoutItems) {
                String fieldLayoutItemId = fieldLayoutItemGV.getString("fieldidentifier");
                if (!TextUtils.stringSet((String)fieldLayoutItemId) || !fieldLayoutItemId.startsWith(CUSTOM_FIELD_STRING) || this.fieldManager.isOrderableField(fieldLayoutItemId)) continue;
                if (correct) {
                    fieldsToRemove.add(fieldLayoutItemId);
                    continue;
                }
                message = this.getI18NBean().getText("admin.integrity.check.field.layout.check.preview", fieldLayoutItemGV.getLong("id").toString(), fieldLayoutItemId);
                results.add(new CheckAmendment(2, message, "JRA-4423"));
            }
            if (correct) {
                for (String fieldLayoutItemId : fieldsToRemove) {
                    this.ofBizDelegator.removeByAnd("FieldLayoutItem", EasyMap.build((Object)"fieldidentifier", (Object)fieldLayoutItemId));
                    message = this.getI18NBean().getText("admin.integrity.check.field.layout.check.message", fieldLayoutItemId);
                    results.add(new CheckAmendment(2, message, "JRA-4423"));
                }
            }
        }
        catch (Exception e) {
            throw new IntegrityException("Error occurred while performing check.", e);
        }
        return results;
    }

    public void setFieldManager(FieldManager fieldManager) {
        this.fieldManager = fieldManager;
    }
}

