/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.validator;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.Validator;
import java.util.Map;

public abstract class AbstractPermissionValidator
implements Validator {
    protected void hasUserPermission(Map args, Map transientVars, User user) throws InvalidInputException {
        String permName = (String)args.get("permission");
        Issue issue = (Issue)transientVars.get("issue");
        PermissionManager permMan = ManagerFactory.getPermissionManager();
        if (issue.getGenericValue() != null) {
            if (permMan.hasPermission(Permissions.getType((String)permName), issue, user)) {
                return;
            }
            throw new InvalidInputException("User '" + user.getName() + "' doesn't have the '" + permName + "' permission");
        }
        if (issue.getProjectObject() != null) {
            if (permMan.hasPermission(Permissions.getType((String)permName), issue.getProjectObject(), user)) {
                return;
            }
            throw new InvalidInputException("User '" + user.getName() + "' doesn't have the '" + permName + "' permission");
        }
        throw new InvalidInputException("Invalid project specified.");
    }
}

