/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.AssignableWorkflowMigrationHelper;
import com.atlassian.jira.workflow.migration.DraftWorkflowMigrationHelper;
import com.atlassian.jira.workflow.migration.MigrationHelperFactory;
import com.google.common.base.Preconditions;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultMigrationHelperFactory
implements MigrationHelperFactory {
    private final WorkflowManager workflowManager;
    private final OfBizDelegator delegator;
    private final SchemeManager schemeManager;
    private final JiraAuthenticationContext authCtx;
    private final ConstantsManager constantsManager;
    private final TaskManager taskManager;
    private final IssueIndexManager issueIndexManager;
    private final WorkflowSchemeManager workflowSchemeManager;

    public DefaultMigrationHelperFactory(WorkflowManager workflowManager, OfBizDelegator delegator, WorkflowSchemeManager schemeManager, ConstantsManager constantsManager, JiraAuthenticationContext authCtx, TaskManager taskManager, IssueIndexManager issueIndexManager, WorkflowSchemeManager workflowSchemeManager) {
        this.workflowManager = workflowManager;
        this.delegator = delegator;
        this.schemeManager = schemeManager;
        this.authCtx = authCtx;
        this.constantsManager = constantsManager;
        this.taskManager = taskManager;
        this.issueIndexManager = issueIndexManager;
        this.workflowSchemeManager = workflowSchemeManager;
    }

    @Override
    public AssignableWorkflowMigrationHelper createMigrationHelper(GenericValue project, AssignableWorkflowScheme scheme) throws GenericEntityException {
        Preconditions.checkNotNull((Object)project, (Object)"project cannot be null.");
        return new AssignableWorkflowMigrationHelper(project, scheme, this.workflowManager, this.delegator, this.schemeManager, this.authCtx.getI18nHelper(), this.authCtx.getLoggedInUser(), this.constantsManager, this.taskManager, this.issueIndexManager, this.workflowSchemeManager);
    }

    @Override
    public DraftWorkflowMigrationHelper createMigrationHelper(GenericValue project, DraftWorkflowScheme draft) throws GenericEntityException {
        Preconditions.checkNotNull((Object)project, (Object)"project cannot be null.");
        return new DraftWorkflowMigrationHelper(project, draft, this.workflowManager, this.delegator, this.schemeManager, this.authCtx.getI18nHelper(), this.authCtx.getLoggedInUser(), this.constantsManager, this.taskManager, this.issueIndexManager, this.workflowSchemeManager);
    }
}

