/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.task.StatefulTaskProgressSink;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.EnterpriseWorkflowTaskContext;
import com.atlassian.jira.workflow.migration.WorkflowMigrationHelper;
import java.util.HashSet;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class AssignableWorkflowMigrationHelper
extends WorkflowMigrationHelper<AssignableWorkflowScheme> {
    AssignableWorkflowMigrationHelper(GenericValue project, AssignableWorkflowScheme targetScheme, WorkflowManager workflowManager, OfBizDelegator delegator, SchemeManager schemeManager, I18nHelper i18nHelper, User user, ConstantsManager constantsManager, TaskManager taskManager, IssueIndexManager issueIndexManager, WorkflowSchemeManager workflowSchemeManager) throws WorkflowException, GenericEntityException {
        super(project, targetScheme, workflowManager, delegator, schemeManager, i18nHelper, user, constantsManager, taskManager, issueIndexManager, workflowSchemeManager);
    }

    @Override
    EnterpriseWorkflowTaskContext createEnterpriseWorkflowTaskContext() {
        return new EnterpriseWorkflowTaskContext(this.projectId, this.schemeId, false);
    }

    @Override
    void complete(SchemeManager schemeManager, GenericValue project, AssignableWorkflowScheme workflowScheme, StatefulTaskProgressSink migrationSink) throws GenericEntityException {
        if (schemeManager == null) {
            throw new NullPointerException();
        }
        if (project == null) {
            throw new NullPointerException();
        }
        List workflowSchemes = schemeManager.getSchemes(project);
        HashSet workflowsFromOldScheme = new HashSet();
        for (GenericValue workflowGV : workflowSchemes) {
            workflowsFromOldScheme.addAll(this.workflowManager.getWorkflowsFromScheme(workflowGV));
        }
        schemeManager.removeSchemesFromProject(project);
        if (workflowScheme != null && workflowScheme.getId() != null) {
            GenericValue scheme = this.workflowSchemeManager.getScheme(workflowScheme.getId());
            schemeManager.addSchemeToProject(project, scheme);
        }
        ComponentAccessor.getWorkflowSchemeManager().clearWorkflowCache();
        this.workflowManager.copyAndDeleteDraftWorkflows(this.getUser(), workflowsFromOldScheme);
    }
}

