/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.worklog.WorklogAdjustmentAmountResult;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateResult;
import com.atlassian.jira.bc.issue.worklog.WorklogResult;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.issue.AbstractWorklogAction;
import com.atlassian.jira.web.util.OutlookDateManager;

public class DeleteWorklog
extends AbstractWorklogAction {
    private Worklog worklog;
    private WorklogResult worklogResult;
    private WorklogManager worklogManager;

    public DeleteWorklog(WorklogService worklogService, CommentService commentService, ProjectRoleManager projectRoleManager, JiraDurationUtils jiraDurationUtils, OutlookDateManager outlookDateManager, FieldVisibilityManager fieldVisibilityManager, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, WorklogManager worklogManager, UserUtil userUtil) {
        super(worklogService, commentService, projectRoleManager, jiraDurationUtils, outlookDateManager, fieldVisibilityManager, fieldLayoutManager, rendererManager, userUtil);
        this.worklogManager = worklogManager;
    }

    public String doDefault() throws Exception {
        this.worklog = this.worklogManager.getById(this.getWorklogId());
        if (this.worklog == null) {
            this.addErrorMessage(this.getText("logwork.error.update.invalid.id", this.getWorklogId() == null ? null : this.getWorklogId().toString()));
            return "error";
        }
        if (!this.worklogService.hasPermissionToDelete(this.getJiraServiceContext(), this.worklog)) {
            return "securitybreach";
        }
        return super.doDefault();
    }

    public void doValidation() {
        this.worklogResult = "new".equalsIgnoreCase(this.adjustEstimate) ? this.worklogService.validateDeleteWithNewEstimate(this.getJiraServiceContext(), this.getWorklogId(), this.getNewEstimate()) : ("manual".equalsIgnoreCase(this.adjustEstimate) ? this.worklogService.validateDeleteWithManuallyAdjustedEstimate(this.getJiraServiceContext(), this.getWorklogId(), this.getAdjustmentAmount()) : this.worklogService.validateDelete(this.getJiraServiceContext(), this.getWorklogId()));
    }

    @RequiresXsrfCheck
    public String doExecute() throws Exception {
        if ("auto".equalsIgnoreCase(this.adjustEstimate)) {
            this.worklogService.deleteAndAutoAdjustRemainingEstimate(this.getJiraServiceContext(), this.worklogResult, true);
        } else if ("new".equalsIgnoreCase(this.adjustEstimate)) {
            this.worklogService.deleteWithNewRemainingEstimate(this.getJiraServiceContext(), (WorklogNewEstimateResult)this.worklogResult, true);
        } else if ("manual".equalsIgnoreCase(this.adjustEstimate)) {
            this.worklogService.deleteWithManuallyAdjustedEstimate(this.getJiraServiceContext(), (WorklogAdjustmentAmountResult)this.worklogResult, true);
        } else {
            this.worklogService.deleteAndRetainRemainingEstimate(this.getJiraServiceContext(), this.worklogResult, true);
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect("/browse/" + this.getIssue().getString("key"));
    }

    public Worklog getWorklog() {
        if (this.worklog == null && this.worklogResult != null) {
            this.worklog = this.worklogResult.getWorklog();
        }
        return this.worklog;
    }
}

