/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.browser;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

public class BrowseProjects
extends JiraWebActionSupport {
    private final WebResourceManager webResourceManager;
    private final UserProjectHistoryManager projectHistoryManager;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final FeatureManager featureManager;
    private final SimpleLinkManager simpleLinkManager;
    private final WebInterfaceManager webInterfaceManager;
    private static final String ALL = "all";
    private static final String NONE = "none";
    private static final String RECENT = "recent";
    private List<ProjectCategoryBean> categories;
    private List<ProjectCategoryBean> tabs;
    private String selectedCategory;

    public BrowseProjects(WebResourceManager webResourceManager, UserProjectHistoryManager projectHistoryManager, ProjectManager projectManager, PermissionManager permissionManager, FeatureManager featureManager, SimpleLinkManager simpleLinkManager, WebInterfaceManager webInterfaceManager) {
        this.webResourceManager = webResourceManager;
        this.projectHistoryManager = projectHistoryManager;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.featureManager = featureManager;
        this.simpleLinkManager = simpleLinkManager;
        this.webInterfaceManager = webInterfaceManager;
    }

    public String getSelectedCategory() throws GenericEntityException {
        if (this.selectedCategory != null) {
            return this.selectedCategory;
        }
        String sessionCategory = this.getSession().get("jira.browse.projects.current.tab");
        if (ALL.equals(sessionCategory)) {
            return sessionCategory;
        }
        String returnKey = null;
        List<ProjectCategoryBean> categories = this.getTabs();
        for (ProjectCategoryBean category : categories) {
            if (returnKey != null && !category.getId().equals(sessionCategory)) continue;
            returnKey = category.getId();
        }
        this.selectedCategory = returnKey == null ? ALL : returnKey;
        return this.selectedCategory;
    }

    public void setSelectedCategory(String selectedCategory) {
        this.getSession().put("jira.browse.projects.current.tab", selectedCategory);
    }

    private Map<String, String> getSession() {
        return ActionContext.getSession();
    }

    public boolean showTabs() throws GenericEntityException {
        return !this.getTabs().isEmpty();
    }

    public List<ProjectCategoryBean> getTabs() throws GenericEntityException {
        if (this.tabs != null) {
            return this.tabs;
        }
        List<ProjectCategoryBean> categories = this.getCategories();
        ArrayList<ProjectCategoryBean> tabs = new ArrayList<ProjectCategoryBean>(categories.size());
        for (ProjectCategoryBean category : categories) {
            if (!category.isTabVisible()) continue;
            tabs.add(category);
        }
        this.tabs = Collections.unmodifiableList(tabs);
        return tabs;
    }

    public List<ProjectCategoryBean> getCategories() throws GenericEntityException {
        if (this.categories == null) {
            ArrayList<ProjectCategoryBean> categories = new ArrayList<ProjectCategoryBean>();
            Collection categoryGVs = this.projectManager.getProjectCategories();
            for (GenericValue categoryGV : categoryGVs) {
                Collection projects = this.permissionManager.getProjects(10, this.getLoggedInUser(), categoryGV);
                if (projects == null || projects.isEmpty()) continue;
                categories.add(new ProjectCategoryBean(categoryGV, projects));
            }
            Collection noCategoryProjects = this.permissionManager.getProjects(10, this.getLoggedInUser(), (GenericValue)null);
            List<GenericValue> recentProjects = this.getRecentGVs();
            if (!noCategoryProjects.isEmpty()) {
                if (categories.isEmpty()) {
                    if (!recentProjects.isEmpty()) {
                        categories.add(new ProjectCategoryBean(this.getText("browse.projects.all"), "", NONE, noCategoryProjects, false, true));
                    } else {
                        categories.add(new ProjectCategoryBean("", "", NONE, noCategoryProjects, false, true));
                    }
                } else {
                    categories.add(new ProjectCategoryBean(this.getText("browse.projects.none"), this.getText("browse.projects.none.desc"), NONE, noCategoryProjects));
                }
            }
            if (!recentProjects.isEmpty()) {
                categories.add(0, new ProjectCategoryBean(this.getText("browse.projects.recent"), this.getText("browse.projects.recent.desc"), RECENT, recentProjects, true, false));
            }
            this.categories = Collections.unmodifiableList(categories);
        }
        return this.categories;
    }

    private List<GenericValue> getRecentGVs() {
        List recentProjects = this.projectHistoryManager.getProjectHistoryWithPermissionChecks(10, this.getLoggedInUser());
        ArrayList<GenericValue> recentGVs = new ArrayList<GenericValue>(recentProjects.size());
        for (Project recentProject : recentProjects) {
            recentGVs.add(recentProject.getGenericValue());
        }
        return recentGVs;
    }

    protected String doExecute() throws Exception {
        this.webResourceManager.requireResource("jira.webresources:browseprojects");
        return super.doExecute();
    }

    public Collection<SimpleLink> getOperationLinks() {
        return this.simpleLinkManager.getLinksForSection("system.browse.projects.operations", this.getLoggedInUser(), this.getJiraHelper());
    }

    private JiraHelper getJiraHelper() {
        HashMap params = new HashMap();
        return new JiraHelper(ServletActionContext.getRequest(), null, params);
    }

    public String getInfoPanelHtml() {
        StringBuilder sb = new StringBuilder();
        List webPanelDescriptors = this.webInterfaceManager.getDisplayableWebPanelDescriptors("webpanels.browse.projects.info-panels", Collections.emptyMap());
        for (WebPanelModuleDescriptor webPanelDescriptor : webPanelDescriptors) {
            sb.append(((WebPanel)webPanelDescriptor.getModule()).getHtml(Collections.emptyMap()));
        }
        return sb.toString();
    }

    public static class ProjectCategoryBean {
        private final Collection<GenericValue> projects;
        private final String name;
        private final String description;
        private final String id;
        private final boolean tabVisible;
        private final boolean includeInAll;

        public ProjectCategoryBean(GenericValue category, Collection<GenericValue> projects) {
            this.projects = projects;
            this.name = category.getString("name");
            String desc = category.getString("description");
            this.description = StringUtils.isBlank((String)desc) ? this.name : this.name + " - " + desc;
            this.id = category.getString("id");
            this.tabVisible = true;
            this.includeInAll = true;
        }

        public ProjectCategoryBean(String name, String description, String id, Collection<GenericValue> projects) {
            this(name, description, id, projects, true, true);
        }

        public ProjectCategoryBean(String name, String description, String id, Collection<GenericValue> projects, boolean tabVisible, boolean inAll) {
            this.projects = projects;
            this.name = name;
            this.description = description;
            this.id = id;
            this.tabVisible = tabVisible;
            this.includeInAll = inAll;
        }

        public boolean hasProject() {
            return this.projects != null && !this.projects.isEmpty();
        }

        public Collection<GenericValue> getProjects() {
            return this.projects;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getId() {
            return this.id;
        }

        public boolean isTabVisible() {
            return this.tabVisible;
        }

        public boolean isAll() {
            return this.includeInAll;
        }
    }
}

