/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowDraftResultAction;
import com.atlassian.jira.workflow.ConfigurableJiraWorkflow;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class ListWorkflows
extends AbstractWorkflowDraftResultAction {
    private final WorkflowManager workflowManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private Collection<JiraWorkflow> workflows;
    private String description;
    private String newWorkflowName;
    private String workflowName;
    private String workflowMode;
    private boolean confirmedDelete;
    private ImmutableList<JiraWorkflow> draftWorkflows;

    public ListWorkflows(WorkflowManager workflowManager, ProjectService projectService, WorkflowSchemeManager workflowSchemeManager) {
        super(projectService);
        this.workflowManager = workflowManager;
        this.workflowSchemeManager = workflowSchemeManager;
    }

    protected String doExecute() throws Exception {
        return "success";
    }

    public String doAddNewWorkflow() throws Exception {
        return "input";
    }

    @RequiresXsrfCheck
    public String doAddWorkflow() throws Exception {
        if (StringUtils.isBlank((String)this.newWorkflowName)) {
            this.addError("newWorkflowName", this.getText("admin.errors.you.must.specify.a.workflow.name"));
        } else if (!WorkflowUtil.isAcceptableName((String)this.newWorkflowName)) {
            this.addError("newWorkflowName", this.getText("admin.errors.please.use.only.ascii.characters"));
        } else if (this.workflowManager.workflowExists(this.newWorkflowName)) {
            this.addError("newWorkflowName", this.getText("admin.errors.a.workflow.with.this.name.already.exists"));
        }
        if (this.invalidInput()) {
            return "input";
        }
        ConfigurableJiraWorkflow newWorkflow = new ConfigurableJiraWorkflow(this.newWorkflowName, this.workflowManager);
        newWorkflow.setDescription(this.description);
        this.workflowManager.createWorkflow(this.getLoggedInUser(), (JiraWorkflow)newWorkflow);
        UrlBuilder builder = new UrlBuilder("EditWorkflowDispatcher.jspa").addParameter("wfName", newWorkflow.getName()).addParameter("atl_token", this.getXsrfToken());
        return this.returnCompleteWithInlineRedirect(builder.asUrlString());
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    @RequiresXsrfCheck
    public String doDeleteWorkflow() throws Exception {
        if (this.confirmedDelete) {
            if ("draft".equals(this.workflowMode)) {
                this.workflowManager.deleteDraftWorkflow(this.workflowName);
                return this.finish("admin.workflows.draft.draftworkflow.was.deleted", this.workflowName);
            }
            JiraWorkflow workflow = this.workflowManager.getWorkflow(this.workflowName);
            if (workflow != null) {
                if (workflow.isEditable()) {
                    Collection workflowSchemes = this.workflowSchemeManager.getSchemesForWorkflow(workflow);
                    if (workflowSchemes == null || workflowSchemes.isEmpty()) {
                        this.workflowManager.deleteWorkflow(this.workflowManager.getWorkflow(this.workflowName));
                        return this.returnCompleteWithInlineRedirect("ListWorkflows.jspa");
                    }
                    StringBuilder schemes = new StringBuilder();
                    for (GenericValue schemeGV : workflowSchemes) {
                        schemes.append('\'').append(schemeGV.getString("name")).append('\'').append(", ");
                    }
                    schemes.delete(schemes.length() - 2, schemes.length() - 1);
                    this.addErrorMessage(this.getText("admin.errors.cannot.delete.this.workflow") + " " + schemes);
                    return this.getResult();
                }
                this.addErrorMessage(this.getText("admin.errors.workflow.cannot.be.deleted.as.it.is.not.editable"));
                return this.getResult();
            }
            this.addErrorMessage(this.getText("admin.errors.workflow.with.name.does.not.exist", "'" + this.workflowName + "'"));
            return this.getResult();
        }
        return "input";
    }

    public Collection<JiraWorkflow> getWorkflows() {
        if (this.workflows == null) {
            this.workflows = this.workflowManager.getWorkflows();
        }
        return this.workflows;
    }

    public List<JiraWorkflow> getActiveWorkflows() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.getWorkflows(), (Predicate)new Predicate<JiraWorkflow>(){

            public boolean apply(JiraWorkflow workflow) {
                return workflow.isActive();
            }
        }));
    }

    public List<JiraWorkflow> getInactiveWorkflows() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.getWorkflows(), (Predicate)new Predicate<JiraWorkflow>(){

            public boolean apply(JiraWorkflow workflow) {
                return !workflow.isActive();
            }
        }));
    }

    public JiraWorkflow getDraftFor(String workflowName) {
        for (JiraWorkflow draft : this.getDraftWorkflows()) {
            if (!draft.getName().equals(workflowName)) continue;
            return draft;
        }
        return null;
    }

    public String getLastModifiedDateForDraft(JiraWorkflow workflow) {
        JiraWorkflow draft = this.getDraftFor(workflow.getName());
        return this.getDateTimeFormatter().withStyle(DateTimeStyle.COMPLETE).format(draft.getUpdatedDate());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public JiraWorkflow getWorkflow() {
        JiraWorkflow workflow = super.getWorkflow();
        if (workflow == null && StringUtils.isNotBlank((String)this.newWorkflowName)) {
            workflow = this.workflowManager.getWorkflow(this.newWorkflowName);
            this.setWorkflow(workflow);
        }
        return workflow;
    }

    public String getNewWorkflowName() {
        return this.newWorkflowName;
    }

    public void setNewWorkflowName(String newWorkflowName) {
        this.newWorkflowName = newWorkflowName;
    }

    public boolean isNoProjects() throws GenericEntityException {
        ServiceOutcome allProjects = this.projectService.getAllProjects(this.getLoggedInUser());
        return !allProjects.isValid() || ((List)allProjects.getReturnedValue()).isEmpty();
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setConfirmedDelete(boolean confirmedDelete) {
        this.confirmedDelete = confirmedDelete;
    }

    public Collection getSchemesForWorkflow(JiraWorkflow workflow) {
        return this.workflowSchemeManager.getSchemesForWorkflow(workflow);
    }

    private void showErrorsForDraftWorkflowsWithAnInactiveParent() {
        for (JiraWorkflow draft : this.getDraftWorkflows()) {
            if (this.isParentWorkflowActive(draft)) continue;
            this.addErrorMessage("The parent workflow of draft '" + draft.getName() + "' is no longer active. Please delete the draft. You may wish to copy the draft before deleting it.");
        }
    }

    private List<JiraWorkflow> getDraftWorkflows() {
        if (this.draftWorkflows == null) {
            ImmutableList.Builder results = ImmutableList.builder();
            List allWorkflows = this.workflowManager.getWorkflowsIncludingDrafts();
            for (JiraWorkflow jiraWorkflow : allWorkflows) {
                if (!jiraWorkflow.isDraftWorkflow()) continue;
                results.add((Object)jiraWorkflow);
            }
            this.draftWorkflows = results.build();
        }
        return this.draftWorkflows;
    }

    public void setWorkflowMode(String workflowMode) {
        this.workflowMode = workflowMode;
    }

    public boolean isParentWorkflowActive(JiraWorkflow workflow) {
        if (!workflow.isDraftWorkflow()) {
            return true;
        }
        JiraWorkflow parentWorkflow = this.workflowManager.getWorkflow(workflow.getName());
        return parentWorkflow != null && parentWorkflow.isActive();
    }
}

