/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowAction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
public class EditWorkflow
extends AbstractWorkflowAction {
    private String workflowName;
    private String newWorkflowName;
    private String description;
    private final WorkflowService workflowService;

    public EditWorkflow(JiraWorkflow jiraWorkflow, WorkflowService workflowService) {
        super(jiraWorkflow);
        this.workflowService = workflowService;
    }

    public String doDefault() throws Exception {
        if (this.workflow.isEditable()) {
            this.newWorkflowName = this.workflow.getName();
            this.description = this.workflow.getDescription();
            return "input";
        }
        this.addErrorMessage(this.getText("admin.errors.workflow.cannot.be.edited.as.it.is.not.editable"));
        return "error";
    }

    protected void doValidation() {
        if (this.workflow.isDraftWorkflow()) {
            this.newWorkflowName = this.workflow.getName();
        }
        this.workflowService.validateUpdateWorkflowNameAndDescription(this.getJiraServiceContext(), this.workflow, this.newWorkflowName);
    }

    @RequiresXsrfCheck
    public String doExecute() throws WorkflowException {
        this.workflowService.updateWorkflowNameAndDescription(this.getJiraServiceContext(), this.workflow, this.newWorkflowName, this.description);
        UrlBuilder builder = new UrlBuilder("EditWorkflowDispatcher.jspa");
        builder.addParameter("wfName", this.newWorkflowName);
        builder.addParameter("atl_token", this.getXsrfToken());
        if (this.getProject() != null) {
            builder.addParameter("project", (Object)this.getProject());
        }
        return this.returnCompleteWithInlineRedirect(builder.asUrlString());
    }

    public String getNewWorkflowName() {
        return this.newWorkflowName;
    }

    public void setNewWorkflowName(String newWorkflowName) {
        this.newWorkflowName = newWorkflowName;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public JiraWorkflow getWorkflow() {
        return this.workflow;
    }
}

