/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.vcs;

import alt.java.io.File;
import alt.java.io.FileImpl;
import com.atlassian.jira.util.LockException;
import com.atlassian.jira.vcs.Repository;
import com.atlassian.jira.vcs.RepositoryManager;
import com.atlassian.jira.vcs.cvsimpl.CvsRepository;
import com.atlassian.jira.vcs.cvsimpl.CvsRepositoryUtil;
import com.atlassian.jira.vcs.cvsimpl.ValidationException;
import com.atlassian.jira.vcs.viewcvs.ViewCvsBrowser;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import net.sf.statcvs.input.LogSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

public class RepositoryActionSupport
extends JiraWebActionSupport {
    protected Long id;
    private String type;
    private String name = null;
    private String description;
    private String logFilePath;
    private String cvsRoot;
    private String moduleName;
    private String password;
    private boolean fetchLog;
    private String timeout;
    private long timeoutMS = 600000L;
    private String repositoryBrowserURL;
    private final RepositoryManager repositoryManager;
    private final CvsRepositoryUtil cvsRepositoryUtil;
    private String repositoryBrowserRootParam;

    public RepositoryActionSupport(RepositoryManager repositoryManager, CvsRepositoryUtil cvsRepositoryUtil) {
        this.repositoryManager = repositoryManager;
        this.cvsRepositoryUtil = cvsRepositoryUtil;
        this.timeout = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(600000L));
    }

    public String doView() {
        return "success";
    }

    public String doDefault() throws Exception {
        if (this.id == null || this.id <= 0L) {
            return this.getRedirect("ViewRepositories.jspa");
        }
        Repository repository = this.getRepositoryManager().getRepository(this.id);
        if (!(repository instanceof CvsRepository)) {
            this.addErrorMessage(this.getText("admin.errors.repository.with.id.not.cvs.repo", this.id.toString()));
            return "error";
        }
        CvsRepository cvsRepository = (CvsRepository)repository;
        this.setType("cvs");
        this.setName(cvsRepository.getName());
        this.setDescription(cvsRepository.getDescription());
        this.setLogFilePath(cvsRepository.getCvsLogFilePath());
        this.setCvsRoot(cvsRepository.getCvsRoot());
        this.setModuleName(cvsRepository.getModuleName());
        this.setPassword(cvsRepository.getPassword());
        this.setFetchLog(cvsRepository.fetchLog());
        this.setTimeoutMillis(cvsRepository.getCvsTimeout());
        if (cvsRepository.getRepositoryBrowser() != null && "VIEW_CVS".equals(cvsRepository.getRepositoryBrowser().getType())) {
            ViewCvsBrowser viewCvsBrowser = (ViewCvsBrowser)cvsRepository.getRepositoryBrowser();
            this.setRepositoryBrowserURL(viewCvsBrowser.getBaseURL());
            this.setRepositoryBrowserRootParam(viewCvsBrowser.getRootParameter());
        }
        return "input";
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = this.getRepositoryManager().isValidType(type) ? type : null;
    }

    public Collection<String> getTypes() {
        return RepositoryManager.VCS_TYPES;
    }

    protected String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public String getCvsRoot() {
        return this.cvsRoot;
    }

    public void setCvsRoot(String cvsRoot) {
        this.cvsRoot = cvsRoot;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public boolean isFetchLog() {
        return this.fetchLog;
    }

    public void setFetchLog(boolean fetchLog) {
        this.fetchLog = fetchLog;
    }

    public String getRepositoryBrowserURL() {
        return this.repositoryBrowserURL;
    }

    public void setRepositoryBrowserURL(String repositoryBrowserURL) {
        this.repositoryBrowserURL = repositoryBrowserURL;
    }

    public String getRepositoryBrowserRootParam() {
        return this.repositoryBrowserRootParam;
    }

    public void setRepositoryBrowserRootParam(String repositoryBrowserRootParam) {
        this.repositoryBrowserRootParam = repositoryBrowserRootParam;
    }

    protected RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public long getTimeoutMillis() {
        return this.timeoutMS;
    }

    private void setTimeoutMillis(long timeoutMs) {
        this.timeoutMS = timeoutMs <= 0L ? 600000L : timeoutMs;
        this.timeout = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(this.timeoutMS));
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
        if (StringUtils.isBlank((String)timeout)) {
            this.timeoutMS = 600000L;
        } else {
            try {
                long ms = Long.parseLong(timeout);
                this.timeoutMS = ms > 0L ? TimeUnit.SECONDS.toMillis(ms) : 600000L;
            }
            catch (NumberFormatException e) {
                this.timeoutMS = 600000L;
            }
        }
    }

    protected String checkRepository(String repositoryName, String logFilePath, String cvsRoot, String moduleName, String password, long cvsTimeout, boolean fetchLog) {
        try {
            this.testRepository(repositoryName, logFilePath, cvsRoot, moduleName, password, cvsTimeout, fetchLog);
        }
        catch (AuthenticationException e) {
            String message = "Error authenticating with the repository: " + e.getLocalizedMessage();
            this.log.error((Object)message, (Throwable)e);
            Throwable cause = e.getUnderlyingThrowable();
            if (cause != null) {
                this.log.error((Object)("Caused by: " + cause.getMessage()), cause);
            }
            return this.getText("admin.errors.authentication.repository", e.getLocalizedMessage());
        }
        catch (LockException e) {
            String message = "Error obtaining lock: " + e.getMessage();
            this.log.error((Object)message, (Throwable)e);
            return this.getText("admin.errors.cvs.obtaining.lock", e.getMessage());
        }
        catch (IOException e) {
            String message = e.getMessage();
            this.log.error((Object)message, (Throwable)e);
            return message;
        }
        catch (CommandException e) {
            this.log.error((Object)"Error occured while retrieving cvs log.", (Throwable)e);
            return this.getText("admin.errors.cvs.retrieving.log", e.getMessage());
        }
        catch (LogSyntaxException e) {
            this.log.error((Object)"Error occured while parsing cvs log.", (Throwable)e);
            return this.getText("admin.errors.cvs.parsing.log", e.getMessage());
        }
        catch (Throwable t) {
            this.log.error((Object)"Error occurred while obtaining cvs log or parsing the cvs log.", t);
            return this.getText("admin.errors.cvs.parsing.or.obtaining.log");
        }
        return null;
    }

    protected void testRepository(String repositoryName, String logFilePath, String cvsRoot, String moduleName, String password, long cvsTimeout, boolean fetchLog) throws AuthenticationException, IOException, CommandException, LogSyntaxException, LockException {
        FileImpl logFile = new FileImpl(logFilePath);
        if (fetchLog) {
            this.cvsRepositoryUtil.updateCvs((File)logFile, cvsRoot, moduleName, password, cvsTimeout);
        } else if (!logFile.exists()) {
            this.addErrorMessage(this.getText("admin.errors.cvs.log.file.not.found", logFile.getPath()));
            return;
        }
        this.cvsRepositoryUtil.parseCvsLogs((File)logFile, moduleName, this.getCvsRepositoryUtil().parseCvsRoot(cvsRoot).getRepository(), repositoryName);
    }

    protected CvsRepositoryUtil getCvsRepositoryUtil() {
        return this.cvsRepositoryUtil;
    }

    public void validateRepositoryParameters() {
        if (!TextUtils.stringSet((String)this.getName())) {
            this.addError("name", this.getText("admin.errors.you.must.specify.a.name.for.the.repository"));
        }
        if (!TextUtils.stringSet((String)this.getCvsRoot())) {
            this.addError("cvsRoot", this.getText("admin.errors.you.must.specify.the.cvs.root.of.the.module"));
        }
        if (!TextUtils.stringSet((String)this.getModuleName())) {
            this.addError("moduleName", this.getText("admin.errors.you.must.specify.the.name.of.the.cvs.module"));
        }
        try {
            if (this.timeout == null || Long.parseLong(this.timeout) < 1L) {
                this.addError("timeout", this.getText("admin.errors.cvs.invalid.timeout"));
            }
        }
        catch (NumberFormatException e) {
            this.addError("timeout", this.getText("admin.errors.cvs.invalid.timeout"));
        }
        if (!TextUtils.stringSet((String)this.getLogFilePath())) {
            this.addError("logFilePath", this.getText("admin.errors.you.must.specify.the.full.path.to.the.cvs.log.file"));
        } else {
            this.checkPathsAndRepository();
        }
        if (TextUtils.stringSet((String)this.getRepositoryBrowserURL())) {
            try {
                new ViewCvsBrowser(this.getRepositoryBrowserURL(), Collections.EMPTY_MAP);
            }
            catch (MalformedURLException e) {
                this.addError("repositoryBrowserURL", this.getText("admin.errors.invalid.url.format"));
            }
        }
    }

    private void checkPathsAndRepository() {
        String message;
        this.checkLogFile();
        this.checkCvsRoot();
        if (!this.invalidInput() && (message = this.checkRepository(this.getName(), this.getLogFilePath(), this.getCvsRoot(), this.getModuleName(), this.getPassword(), this.getTimeoutMillis(), this.isFetchLog())) != null) {
            this.addErrorMessage(message);
        }
    }

    private void checkCvsRoot() {
        try {
            this.getCvsRepositoryUtil().checkCvsRoot(this.getCvsRoot());
        }
        catch (ValidationException e) {
            this.addError("cvsRoot", e.getMessage());
        }
    }

    private void checkLogFile() {
        try {
            FileImpl file = new FileImpl(this.getLogFilePath());
            this.getCvsRepositoryUtil().checkLogFilePath((File)file, this.isFetchLog());
        }
        catch (ValidationException e) {
            this.addError("logFilePath", e.getMessage());
        }
    }
}

