/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.util.NotNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamCopyingConsumer
implements Consumer<InputStream> {
    private final OutputStream outputStream;
    private int bufferSize;

    public StreamCopyingConsumer(OutputStream outputStream, int bufferSize) {
        this.outputStream = outputStream;
        this.bufferSize = bufferSize;
    }

    public void consume(@NotNull InputStream inputStream) {
        try {
            IOUtil.copy(inputStream, this.outputStream, this.bufferSize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

