/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.RegexpUtils;
import com.atlassian.jira.util.collect.Transformed;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class JiraVelocityHelper {
    private static final Logger log = Logger.getLogger(JiraVelocityHelper.class);
    private static final String lSep = System.getProperty("line.separator");
    private static final int CHANGELOG_WHITESPACE_INDENT = 4;
    private final FieldManager fieldManager;

    public JiraVelocityHelper(FieldManager fieldManager) {
        this.fieldManager = fieldManager;
    }

    public String urlencode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, ComponentAccessor.getApplicationProperties().getEncoding());
    }

    public String quote(String in) {
        return this.indentTextBlock(in, "> ", true);
    }

    public String quoteExceptFirst(String in) {
        return this.indentTextBlock(in, "> ", false);
    }

    public String indentTextBlock(String in, String indentStr, boolean quoteFirst) {
        if (in == null || in.length() == 0) {
            return "";
        }
        StringBuilder out = new StringBuilder(in.length() * 2);
        StringTokenizer tok = new StringTokenizer(in, "\n\r");
        boolean first = true;
        while (tok.hasMoreElements()) {
            String line = (String)tok.nextElement();
            if (first) {
                out.append((quoteFirst ? indentStr : "") + line);
                first = false;
            } else {
                out.append(indentStr + line);
            }
            if (!tok.hasMoreElements()) continue;
            out.append(lSep);
        }
        return out.toString();
    }

    public String getFieldName(String fieldKey, I18nHelper i18n) {
        Field field = this.fieldManager.getField(fieldKey);
        if (field == null) {
            return fieldKey;
        }
        return i18n.getText(field.getNameKey());
    }

    public String getFieldName(GenericValue changeItem, I18nHelper i18n) {
        String field = changeItem.getString("field");
        if (changeItem.getString("fieldtype").toLowerCase().equals("custom")) {
            return field;
        }
        String fieldKey = StringUtils.replaceAll((String)field, (String)" ", (String)"").toLowerCase();
        return i18n.getText("issue.field." + fieldKey);
    }

    public String getOldKey(GenericValue changelog) throws GenericEntityException {
        List changeItems = changelog.getRelated("ChildChangeItem");
        for (GenericValue changeItem : changeItems) {
            String fieldKey = changeItem.getString("field");
            if (!"Key".equals(fieldKey)) continue;
            return changeItem.getString("oldstring");
        }
        return "";
    }

    public String getNewKey(GenericValue changelog) throws GenericEntityException {
        List changeItems = changelog.getRelated("ChildChangeItem");
        for (GenericValue changeItem : changeItems) {
            String fieldKey = changeItem.getString("field");
            if (!"Key".equals(fieldKey)) continue;
            return changeItem.getString("newstring");
        }
        return "";
    }

    public String printChangelog(GenericValue changelog, I18nHelper i18n, Collection<String> ignoredFields) throws GenericEntityException {
        return this.printChangelog(changelog, i18n, ignoredFields, true);
    }

    public String printChangelog(GenericValue changelog, I18nHelper i18n, Collection<String> ignoredFields, boolean ignoreStatus) throws GenericEntityException {
        ArrayList<String> ignoredFieldList = new ArrayList<String>(ignoredFields);
        if (ignoreStatus) {
            ignoredFieldList.add("status");
        }
        List changeItems = changelog.getRelated("ChildChangeItem");
        int maxFieldLength = this.getMaxFieldLength(changeItems, i18n);
        StringBuilder result = new StringBuilder();
        String fieldKey = "";
        String prevFieldKey = "undefined";
        for (GenericValue changeItem : changeItems) {
            int i;
            prevFieldKey = fieldKey;
            fieldKey = changeItem.getString("field");
            String oldStr = changeItem.getString("oldstring");
            String newStr = changeItem.getString("newstring");
            boolean isCommentDeleted = false;
            if ("Comment".equals(fieldKey)) {
                isCommentDeleted = true;
                oldStr = changeItem.getString("oldvalue");
                newStr = changeItem.getString("newvalue");
            }
            oldStr = this.getPrettyFieldString(fieldKey, oldStr, i18n);
            newStr = this.getPrettyFieldString(fieldKey, newStr, i18n);
            if (ignoredFieldList.contains(fieldKey)) continue;
            String fieldValue = oldStr != null && newStr != null ? (this.multiLine(newStr) ? lSep + newStr + lSep + lSep + "  " + i18n.getText("template.changelog.was") + ":" + (this.multiLine(oldStr) ? lSep : "") + oldStr + lSep : newStr + "  (" + i18n.getText("template.changelog.was") + ": " + oldStr + ")") : (oldStr != null ? (isCommentDeleted ? i18n.getText("template.changelog.was.deleted") + "\n\n(" + i18n.getText("template.changelog.was") + ": " + oldStr + ")" : "    (" + i18n.getText("template.changelog.was") + ": " + oldStr + ")") : (newStr != null ? (this.multiLine(newStr) ? lSep : "") + newStr : i18n.getText("template.changelog.was.deleted")));
            String fieldName = this.getFieldName(changeItem, i18n);
            if (!prevFieldKey.equals(fieldKey)) {
                for (i = -4; i < maxFieldLength - fieldName.length(); ++i) {
                    result.append(" ");
                }
                result.append(fieldName).append(": ");
            } else {
                for (i = -4; i < maxFieldLength; ++i) {
                    result.append(" ");
                }
                result.append("  ");
            }
            result.append(fieldValue).append(lSep);
        }
        return result.toString();
    }

    public boolean wasDeleted(GenericValue changelog, String fieldKey, I18nHelper i18n) throws GenericEntityException {
        if (changelog != null) {
            List changeItems = changelog.getRelated("ChildChangeItem");
            for (GenericValue changeItem : changeItems) {
                String field = changeItem.getString("field");
                if (!field.equals(fieldKey)) continue;
                String oldStr = this.getPrettyFieldString(fieldKey, changeItem.getString("oldstring"), i18n);
                String newStr = this.getPrettyFieldString(fieldKey, changeItem.getString("newstring"), i18n);
                if (oldStr != null || newStr != null) continue;
                return true;
            }
        }
        return false;
    }

    public String getPrettyFieldString(String fieldKey, String str, I18nHelper i18n) {
        if (this.fieldManager.isNavigableField(fieldKey)) {
            NavigableField field = this.fieldManager.getNavigableField(fieldKey);
            if (field != null) {
                str = field.prettyPrintChangeHistory(str, i18n);
            }
        } else {
            log.info((Object)("FieldKey " + fieldKey + " is an invalid field. No translation of change history will occur"));
        }
        return str;
    }

    public String getPrettyFieldString(String fieldKey, String str, I18nHelper i18n, String defaultIfNull) {
        return this.getPrettyFieldString(fieldKey, str, i18n) != null ? this.getPrettyFieldString(fieldKey, str, i18n) : defaultIfNull;
    }

    public String indentToChangelog(String fieldName, String fieldValue, GenericValue changelog, I18nHelper i18n) throws GenericEntityException {
        int maxFieldLength;
        StringBuilder result = new StringBuilder();
        if (changelog != null) {
            List changeItems = changelog.getRelated("ChildChangeItem");
            maxFieldLength = this.getMaxFieldLength(changeItems, i18n);
        } else {
            maxFieldLength = 10;
        }
        for (int i = -4; i < maxFieldLength - fieldName.length(); ++i) {
            result.append(" ");
        }
        result.append(fieldName).append(": ").append(fieldValue).append(lSep);
        return result.toString();
    }

    public String indentToChangelogNoLineSep(String fieldName, String fieldValue, I18nHelper i18n, List<String> allFieldNames) throws GenericEntityException {
        StringBuilder result = new StringBuilder();
        int indent = allFieldNames != null ? this.getMaxFieldLength(allFieldNames) : 10;
        for (int i = -4; i < indent - fieldName.length(); ++i) {
            result.append(" ");
        }
        result.append(fieldName).append(": ").append(fieldValue);
        return result.toString();
    }

    private int getMaxFieldLength(List<GenericValue> changeItems, final I18nHelper i18n) {
        return this.getMaxFieldLength(Transformed.list(changeItems, (Function)new Function<GenericValue, String>(){

            public String get(GenericValue changeItem) {
                return JiraVelocityHelper.this.getFieldName(changeItem, i18n);
            }
        }));
    }

    private int getMaxFieldLength(List<String> fieldNames) {
        int maxFieldLength = 0;
        for (String fieldName : fieldNames) {
            if (fieldName.length() <= maxFieldLength) continue;
            maxFieldLength = fieldName.length();
        }
        return maxFieldLength;
    }

    private boolean multiLine(String newStr) {
        return newStr.indexOf(13) != -1 || newStr.indexOf(10) != -1;
    }

    public Map newMap() {
        return new LinkedHashMap();
    }

    public Map newMap(Object k1, Object v1) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        map.put(k1, v1);
        return map;
    }

    public Map newMap(Object k1, Object v1, Object k2, Object v2) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public String removeHtmlBreaks(String str) {
        str = StringUtils.replaceAll((String)str, (String)"<br>", (String)"");
        str = StringUtils.replaceAll((String)str, (String)"<br/>", (String)"");
        str = StringUtils.replaceAll((String)str, (String)"<br />", (String)"");
        str = StringUtils.replaceAll((String)str, (String)"<p>", (String)"");
        str = StringUtils.replaceAll((String)str, (String)"</p>", (String)"");
        return str;
    }

    public String removeHtmlTags(String str) {
        return RegexpUtils.replaceAll((String)str, (String)"<[^>]*>", (String)" ");
    }
}

