/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.upgrade.util.SearchRequestConverter;
import com.atlassian.jira.upgrade.util.UsersGroupParamConverter;
import java.io.InputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;

public class XsltSearchRequestTransformer
implements SearchRequestConverter {
    private static final Logger log = Logger.getLogger(UsersGroupParamConverter.class);
    protected final Transformer transformer;

    public XsltSearchRequestTransformer(String upgradeXslFilename) {
        InputStream xslStream = ClassLoaderUtils.getResourceAsStream((String)upgradeXslFilename, this.getClass());
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            this.transformer = factory.newTransformer(new StreamSource(xslStream));
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("Could not parse XSLT " + upgradeXslFilename + " used for upgrading search requests");
        }
    }

    @Override
    public Document process(Document document) {
        DocumentSource source = new DocumentSource(document);
        DocumentResult result = new DocumentResult();
        try {
            this.transformer.transform((Source)source, (Result)result);
        }
        catch (TransformerException e) {
            log.error((Object)("Error converting searchrequest document " + document + " returning original search request"));
            return document;
        }
        return result.getDocument();
    }
}

