/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.websudo;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.security.websudo.InbuiltAuthenticatorCheck;
import com.atlassian.jira.security.websudo.InternalWebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.util.concurrent.Nullable;
import com.google.common.base.Preconditions;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import webwork.action.Action;

public class InternalWebSudoManagerImpl
implements InternalWebSudoManager {
    private static final String REQUEST_ATTRIBUTE = "jira.websudo.request";
    private static final String REQUIRE_AUTHENTICATION = "Require-Authentication";
    private static final String HAS_AUTHENTICATION = "Has-Authentication";
    public static final String WEBSUDO = "X-Atlassian-WebSudo";
    private final ApplicationProperties applicationProperties;

    public InternalWebSudoManagerImpl(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public boolean isEnabled() {
        return !JiraSystemProperties.isWebSudoDisabled() && !this.applicationProperties.getOption("jira.websudo.is.disabled") && !InbuiltAuthenticatorCheck.hasCustomAuthenticator();
    }

    @Override
    public boolean matches(Class<? extends Action> actionClass) {
        return actionClass.getAnnotation(WebSudoRequired.class) != null;
    }

    @Override
    public boolean hasValidSession(@Nullable HttpSession session) {
        if (null == session) {
            return false;
        }
        String timeoutString = this.applicationProperties.getDefaultBackedString("jira.websudo.timeout");
        int timeout = StringUtils.isNotBlank((String)timeoutString) ? Integer.valueOf(timeoutString) : 10;
        Long timestamp = (Long)session.getAttribute("jira.websudo.timestamp");
        long timeoutMillis = timeout * 60 * 1000;
        return timestamp != null && timestamp >= this.currentTimeMillis() - timeoutMillis;
    }

    @Override
    public boolean isWebSudoRequest(@Nullable HttpServletRequest request) {
        return null != request && Boolean.TRUE.equals(request.getAttribute(REQUEST_ATTRIBUTE));
    }

    @Override
    public void startSession(HttpServletRequest request, HttpServletResponse response) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)response);
        this.markWebSudoRequest(request);
        response.setHeader(WEBSUDO, HAS_AUTHENTICATION);
    }

    @Override
    public void markWebSudoRequest(@Nullable HttpServletRequest request) {
        if (null == request) {
            return;
        }
        request.getSession(true).setAttribute("jira.websudo.timestamp", (Object)this.currentTimeMillis());
        request.setAttribute(REQUEST_ATTRIBUTE, (Object)Boolean.TRUE);
    }

    @Override
    public void invalidateSession(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session;
        HttpSession httpSession = session = null != request ? request.getSession(false) : null;
        if (null != session) {
            session.removeAttribute("jira.websudo.timestamp");
        }
        response.setHeader(WEBSUDO, REQUIRE_AUTHENTICATION);
    }

    long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

