/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.jira.security.JiraPermission;
import org.ofbiz.core.entity.GenericValue;

public class JiraPermissionImpl
implements JiraPermission {
    private final int type;
    private final Long scheme;
    private String permType;
    private String group;

    public JiraPermissionImpl(int type) {
        this.type = type;
        this.scheme = null;
        this.permType = "group";
    }

    public JiraPermissionImpl(int type, String group, String permType) {
        this.type = type;
        this.scheme = null;
        this.group = group;
        this.permType = permType;
    }

    public JiraPermissionImpl(GenericValue permission) {
        this.type = permission.getLong("permission").intValue();
        this.scheme = permission.getLong("scheme");
        this.group = permission.getString("parameter");
        this.permType = permission.getString("type");
    }

    public JiraPermissionImpl(int type, Long scheme, String group, String permType) {
        this.type = type;
        this.scheme = scheme != null && scheme >= 0L ? scheme : null;
        this.group = group;
        this.permType = permType;
    }

    public JiraPermissionImpl(int type, GenericValue scheme, String group, String permType) {
        this.type = type;
        this.scheme = scheme == null ? null : scheme.getLong("id");
        this.group = group;
        this.permType = permType;
    }

    public int getType() {
        return this.type;
    }

    public Long getScheme() {
        return this.scheme;
    }

    public String getGroup() {
        return this.group;
    }

    public String getPermType() {
        return this.permType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JiraPermissionImpl)) {
            return false;
        }
        JiraPermissionImpl jiraPermission = (JiraPermissionImpl)o;
        if (this.type != jiraPermission.type) {
            return false;
        }
        if (this.group != null ? !this.group.equals(jiraPermission.group) : jiraPermission.group != null) {
            return false;
        }
        if (this.permType != null ? !this.permType.equals(jiraPermission.permType) : jiraPermission.permType != null) {
            return false;
        }
        return !(this.scheme != null ? !this.scheme.equals(jiraPermission.scheme) : jiraPermission.scheme != null);
    }

    public int hashCode() {
        int result = this.type;
        result = 29 * result + (this.scheme != null ? this.scheme.hashCode() : 0);
        result = 29 * result + (this.permType != null ? this.permType.hashCode() : 0);
        result = 29 * result + (this.group != null ? this.group.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Permission: [type=" + this.type + "][scheme=" + this.scheme + "][group=" + this.group + "][permType=" + this.permType + "]";
    }
}

