/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.NotNull;
import java.util.Collection;
import org.ofbiz.core.entity.GenericValue;

public class ProjectImpl
implements Project {
    private final GenericValue projectGV;
    private final String key;
    private User lead;

    public ProjectImpl(GenericValue projectGv) {
        this.projectGV = projectGv;
        this.key = this.getStringFromGV("key");
    }

    public Long getId() {
        return this.getLongFromGV("id");
    }

    public String getName() {
        return this.getStringFromGV("name");
    }

    public String getKey() {
        return this.key;
    }

    public String getUrl() {
        return this.getStringFromGV("url");
    }

    public User getLead() {
        if (this.getLeadUserName() != null && this.lead == null) {
            this.lead = this.getUser(this.getLeadUserName());
        }
        return this.lead;
    }

    public User getLeadUser() {
        return this.getLead();
    }

    public String getLeadUserName() {
        return this.getStringFromGV("lead");
    }

    public String getDescription() {
        String value = this.getStringFromGV("description");
        return value == null ? "" : value;
    }

    public Long getAssigneeType() {
        return this.getLongFromGV("assigneetype");
    }

    public Long getCounter() {
        return ComponentAccessor.getProjectManager().getCurrentCounterForProject(this.getId());
    }

    public Collection<GenericValue> getComponents() {
        return ComponentAccessor.getProjectManager().getComponents(this.projectGV);
    }

    public Collection<ProjectComponent> getProjectComponents() {
        return ComponentAccessor.getProjectComponentManager().findAllForProject(this.getId());
    }

    public Collection<Version> getVersions() {
        return ComponentAccessor.getVersionManager().getVersions(this.projectGV.getLong("id"));
    }

    public Collection<IssueType> getIssueTypes() {
        return ComponentManager.getComponent(IssueTypeSchemeManager.class).getIssueTypesForProject((Project)this);
    }

    public GenericValue getProjectCategory() {
        return ComponentAccessor.getProjectManager().getProjectCategoryFromProject(this.projectGV);
    }

    public ProjectCategory getProjectCategoryObject() {
        return ComponentAccessor.getProjectManager().getProjectCategoryForProject((Project)this);
    }

    @NotNull
    public Avatar getAvatar() {
        return ComponentAccessor.getAvatarManager().getById(this.getLongFromGV("avatar"));
    }

    public GenericValue getGenericValue() {
        return this.projectGV;
    }

    private String getStringFromGV(String key) {
        if (this.projectGV != null) {
            return this.projectGV.getString(key);
        }
        return null;
    }

    private Long getLongFromGV(String key) {
        if (this.projectGV != null) {
            return this.projectGV.getLong(key);
        }
        return null;
    }

    private User getUser(String username) {
        return UserUtils.getUserEvenWhenUnknown((String)username);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        if (this.getKey() == null) {
            return other.getKey() == null;
        }
        return this.getKey().equals(other.getKey());
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public String toString() {
        return "Project: " + this.getKey();
    }
}

