/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.workflow;

import com.atlassian.jira.permission.Permission;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowPluginFactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;

public abstract class AbstractWorkflowPermissionPluginFactory
extends AbstractWorkflowPluginFactory {
    private final SchemePermissions schemePermissions;

    public AbstractWorkflowPermissionPluginFactory(SchemePermissions schemePermissions) {
        this.schemePermissions = schemePermissions;
    }

    protected void getVelocityParamsForInput(Map<String, Object> velocityParams) {
        Map<String, Map<Integer, Permission>> permissions = this.getGroupedPermissions();
        velocityParams.put("permissions", Collections.unmodifiableMap(permissions));
    }

    protected Map<String, Map<Integer, Permission>> getGroupedPermissions() {
        LinkedHashMap<String, Map<Integer, Permission>> permissions = new LinkedHashMap<String, Map<Integer, Permission>>();
        permissions.put("admin.permission.group.project.permissions", this.schemePermissions.getProjectPermissions());
        permissions.put("admin.permission.group.issue.permissions", this.schemePermissions.getIssuePermissions());
        permissions.put("admin.permission.group.voters.and.watchers.permissions", this.schemePermissions.getVotersAndWatchersPermissions());
        permissions.put("admin.permission.group.comments.permissions", this.schemePermissions.getCommentsPermissions());
        permissions.put("admin.permission.group.attachments.permissions", this.schemePermissions.getAttachmentsPermissions());
        permissions.put("admin.permission.group.time.tracking.permissions", this.schemePermissions.getTimeTrackingPermissions());
        TreeSet<Integer> otherPermissionKeys = new TreeSet<Integer>(this.schemePermissions.getSchemePermissions().keySet());
        otherPermissionKeys.removeAll(this.schemePermissions.getProjectPermissions().keySet());
        otherPermissionKeys.removeAll(this.schemePermissions.getIssuePermissions().keySet());
        otherPermissionKeys.removeAll(this.schemePermissions.getVotersAndWatchersPermissions().keySet());
        otherPermissionKeys.removeAll(this.schemePermissions.getCommentsPermissions().keySet());
        otherPermissionKeys.removeAll(this.schemePermissions.getAttachmentsPermissions().keySet());
        otherPermissionKeys.removeAll(this.schemePermissions.getTimeTrackingPermissions().keySet());
        if (!otherPermissionKeys.isEmpty()) {
            LinkedHashMap<Integer, Permission> otherPermissions = new LinkedHashMap<Integer, Permission>();
            for (Integer key : otherPermissionKeys) {
                otherPermissions.put(key, this.schemePermissions.getSchemePermissions().get(key));
            }
            permissions.put("admin.permission.group.other.permissions", otherPermissions);
        }
        return permissions;
    }
}

