/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.web.Condition;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class CanAdministerProjectCondition
implements Condition {
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authContext;
    private final ProjectManager projectManager;

    public CanAdministerProjectCondition(PermissionManager permissionManager, JiraAuthenticationContext authContext, ProjectManager projectManager) {
        this.permissionManager = permissionManager;
        this.authContext = authContext;
        this.projectManager = projectManager;
    }

    public void init(Map<String, String> params) {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        User user = this.authContext.getLoggedInUser();
        Project project = this.getProject(context);
        if (project == null) {
            return false;
        }
        HttpServletRequest request = this.getRequest();
        if (request == null) {
            return this.hasPermission(user, project);
        }
        String name = user == null ? "" : user.getName();
        String cacheKey = String.format("atl.jira.permission.request.cache:%s:%s:%s", 23, name, project.getKey());
        Object cachedPermission = request.getAttribute(cacheKey);
        if (cachedPermission == null || !(cachedPermission instanceof Boolean)) {
            boolean permission = this.hasPermission(user, project);
            request.setAttribute(cacheKey, (Object)permission);
            return permission;
        }
        return (Boolean)cachedPermission;
    }

    @VisibleForTesting
    HttpServletRequest getRequest() {
        return ExecutingHttpRequest.get();
    }

    private boolean hasPermission(User user, Project project) {
        try {
            return this.permissionManager.hasPermission(0, user) || this.permissionManager.hasPermission(23, project, user);
        }
        catch (Exception e) {
            return false;
        }
    }

    private Project getProject(Map<String, Object> context) {
        JiraHelper helper;
        if (context.containsKey("project")) {
            return (Project)context.get("project");
        }
        if (context.containsKey("issue")) {
            return ((Issue)context.get("issue")).getProjectObject();
        }
        if (context.containsKey("helper") && (helper = (JiraHelper)context.get("helper")).getProjectObject() != null) {
            return helper.getProjectObject();
        }
        if (context.containsKey("version")) {
            return ((Version)context.get("version")).getProjectObject();
        }
        if (context.containsKey("component")) {
            Long projectId = ((ProjectComponent)context.get("component")).getProjectId();
            return this.projectManager.getProjectObj(projectId);
        }
        return null;
    }
}

