/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.renderercomponent;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.OrderableModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorXMLUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.renderer.v2.components.PluggableRendererComponentFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class RendererComponentFactoryDescriptor
extends AbstractJiraModuleDescriptor<PluggableRendererComponentFactory>
implements OrderableModuleDescriptor {
    private int order = 0;
    private Map<String, List<String>> listParams = new HashMap<String, List<String>>();

    public RendererComponentFactoryDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        List valueElements;
        super.init(plugin, element);
        Element paramListElement = element.element("list-param");
        if (paramListElement != null && (valueElements = paramListElement.elements("value")) != null && !valueElements.isEmpty()) {
            ArrayList<String> paramList = new ArrayList<String>();
            for (Element valueElement : valueElements) {
                paramList.add(valueElement.getTextTrim());
            }
            this.listParams.put(paramListElement.attribute("name").getText(), paramList);
        }
        this.order = ModuleDescriptorXMLUtils.getOrder((Element)element);
    }

    @Override
    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(PluggableRendererComponentFactory.class);
    }

    public Map<String, List<String>> getListParams() {
        return this.listParams;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean hasHelp() {
        return this.getResourceDescriptor("velocity", "help") != null;
    }

    public String getHelpSection() {
        return this.getResourceDescriptor("velocity", "help").getParameter("help-section");
    }

    public String getHelp() {
        return this.getHtml("help");
    }
}

