/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.impl;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentComparator;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.plugin.projectpanel.impl.AbstractProjectTabPanel;
import com.atlassian.jira.plugin.projectpanel.impl.PermissionHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ComponentsProjectTabPanel
extends AbstractProjectTabPanel {
    private static final Logger log = Logger.getLogger(ComponentsProjectTabPanel.class);
    private final PermissionHelper permissionHelper;
    private final ProjectComponentManager projectComponentManager;
    private final FieldVisibilityManager fieldVisibilityManager;

    public ComponentsProjectTabPanel(PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, ProjectComponentManager projectComponentManager, FieldVisibilityManager fieldVisibilityManager) {
        super(authenticationContext);
        this.projectComponentManager = projectComponentManager;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.permissionHelper = new PermissionHelper(permissionManager);
    }

    public boolean showPanel(BrowseContext ctx) {
        Long projectId = ctx.getProject().getId();
        return this.isComponentsFieldVisible(projectId) && !this.projectComponentManager.findAllForProject(projectId).isEmpty();
    }

    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        List<ProjectComponent> components = this.getComponents(ctx.getProject());
        Map params = super.createVelocityParams(ctx);
        params.put("components", components);
        params.put("hasAdminPermission", this.permissionHelper.hasProjectAdminPermission(this.authenticationContext.getLoggedInUser(), ctx.getProject()));
        params.put("tabpanel", this);
        return params;
    }

    protected boolean isComponentsFieldVisible(Long projectId) {
        return !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(projectId, "components", null);
    }

    public boolean isUserExists(String username) {
        return UserUtils.userExists((String)username);
    }

    private List<ProjectComponent> getComponents(Project project) {
        List<ProjectComponent> components = Collections.emptyList();
        if (this.isComponentsFieldVisible(project.getId())) {
            try {
                components = new ArrayList<ProjectComponent>(this.projectComponentManager.findAllForProject(project.getId()));
                Collections.sort(components, ProjectComponentComparator.INSTANCE);
            }
            catch (DataAccessException e) {
                log.error((Object)("Could not retrieve components for project: " + project), (Throwable)e);
            }
        }
        return components;
    }
}

