/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.fragment.impl;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlOrderByBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.plugin.projectpanel.fragment.ProjectTabPanelFragment;
import com.atlassian.jira.plugin.projectpanel.fragment.impl.AbstractUnresolvedIssuesFragment;
import com.atlassian.jira.plugin.projectpanel.fragment.impl.AbstractUrlFragmentUtil;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SortOrder;
import java.util.Map;
import org.apache.log4j.Logger;

public class UnresolvedIssuesByAssigneeFragment
extends AbstractUnresolvedIssuesFragment
implements ProjectTabPanelFragment {
    private static final Logger log = Logger.getLogger(UnresolvedIssuesByAssigneeFragment.class);
    private final ApplicationProperties applicationProperties;
    private final UserFormatManager userFormatManager;

    public UnresolvedIssuesByAssigneeFragment(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, UserFormatManager userFormatManager) {
        super(templatingEngine, jiraAuthenticationContext);
        this.applicationProperties = applicationProperties;
        this.userFormatManager = userFormatManager;
    }

    @Override
    public String getId() {
        return "unresolvedissuesbyassignee";
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("userformat", this.userFormatManager.getUserFormat("fullName"));
        StatisticMapWrapper assignees = this.getAssignees(ctx);
        velocityParams.put("assignees", assignees);
        velocityParams.put("urlUtil", new AssigneeUrlUtil(this.getSearchRequest(ctx), this.authenticationContext.getLoggedInUser(), this.applicationProperties));
        return velocityParams;
    }

    @Override
    String getIssueFieldConstant() {
        return "assignee";
    }

    StatisticMapWrapper getAssignees(BrowseContext ctx) {
        try {
            return this.getStatsBean(ctx).getAllFilterBy("assignees");
        }
        catch (SearchException e) {
            log.error((Object)("Could not search for assignees in project '" + ctx.getProject().getKey() + "'"), (Throwable)e);
            return null;
        }
    }

    public static class AssigneeUrlUtil
    extends AbstractUrlFragmentUtil<User> {
        public AssigneeUrlUtil(SearchRequest searchRequest, User user, ApplicationProperties applicationProperties) {
            super(searchRequest, user, applicationProperties);
        }

        @Override
        protected Clause getDomainClause(User user) {
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
            if (user != null) {
                builder.assignee().eq(user.getName());
            } else {
                builder.assigneeIsEmpty();
            }
            return builder.buildClause();
        }

        @Override
        protected OrderBy getOrderBy() {
            JqlOrderByBuilder jqlOrderByBuilder = JqlQueryBuilder.newOrderByBuilder();
            jqlOrderByBuilder.assignee(SortOrder.ASC);
            return jqlOrderByBuilder.buildOrderBy();
        }
    }
}

