/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.GuardedBy;

@EventComponent
public class JiraPluginPersistentStateStore
implements PluginPersistentStateStore {
    private final ApplicationProperties applicationProperties;
    private volatile Cache cache;

    public JiraPluginPersistentStateStore(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        this.reloadKeys();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.reloadKeys();
    }

    private void reloadKeys() {
        this.cache = new Cache(this.applicationProperties.getStringsWithPrefix("jira.plugin.state-"));
    }

    public synchronized void save(PluginPersistentState state) {
        this.cache.resetDatabase();
        Map map = state.getMap();
        for (Map.Entry entry : map.entrySet()) {
            this.applicationProperties.setString("jira.plugin.state-." + (String)entry.getKey(), ((Boolean)entry.getValue()).toString());
        }
        this.reloadKeys();
    }

    public PluginPersistentState load() {
        return this.cache.getState();
    }

    class Cache {
        private final Set<String> keys;
        private final PluginPersistentState state;

        Cache(Collection<String> keys) {
            int statePrefixIndex = "jira.plugin.state-".length() + 1;
            this.keys = keys == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(keys));
            HashMap<String, Boolean> stateMap = new HashMap<String, Boolean>();
            for (String key : this.keys) {
                stateMap.put(key.substring(statePrefixIndex), Boolean.valueOf(JiraPluginPersistentStateStore.this.applicationProperties.getString(key)));
            }
            this.state = PluginPersistentState.Builder.create().addState(stateMap).toState();
        }

        public PluginPersistentState getState() {
            return this.state;
        }

        @GuardedBy(value="JiraPluginPersistentStateStore.this")
        void resetDatabase() {
            for (String element : this.keys) {
                JiraPluginPersistentStateStore.this.applicationProperties.setString(element, null);
            }
        }
    }
}

