/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.plugin.PluginFactoryAndLoaderRegistrar;
import com.atlassian.jira.plugin.PluginLoaderFactory;
import com.atlassian.jira.plugin.PluginPath;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.loaders.ClassPathPluginLoader;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.servlet.ServletContextFactory;
import java.util.List;
import org.apache.log4j.Logger;

public class DefaultPluginLoaderFactory
implements PluginLoaderFactory {
    private static final Logger log = Logger.getLogger(DefaultPluginLoaderFactory.class);
    private final PluginFactoryAndLoaderRegistrar pluginFactoryAndLoaderRegistrar;

    public DefaultPluginLoaderFactory(PluginEventManager pluginEventManager, OsgiContainerManager osgiContainerManager, PluginPath pathFactory, ServletContextFactory servletContextFactory) {
        this.pluginFactoryAndLoaderRegistrar = new PluginFactoryAndLoaderRegistrar(pluginEventManager, osgiContainerManager, pathFactory, servletContextFactory);
    }

    @Override
    public List<PluginLoader> getPluginLoaders() {
        List<PluginFactory> pluginFactories = this.pluginFactoryAndLoaderRegistrar.getDefaultPluginFactories();
        CollectionBuilder pluginLoaderBuilder = CollectionBuilder.newBuilder();
        pluginLoaderBuilder.addAll(this.pluginFactoryAndLoaderRegistrar.getDefaultSystemPluginLoaders());
        pluginLoaderBuilder.add((Object)new ClassPathPluginLoader());
        if (JiraSystemProperties.isBundledPluginsDisabled()) {
            log.warn((Object)"Bundled plugins have been disabled. Removing bundled plugin loader.");
        } else {
            pluginLoaderBuilder.add((Object)this.pluginFactoryAndLoaderRegistrar.getBundledPluginsLoader(pluginFactories));
        }
        pluginLoaderBuilder.add((Object)this.pluginFactoryAndLoaderRegistrar.getDirectoryPluginLoader(pluginFactories));
        return pluginLoaderBuilder.asList();
    }
}

