/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.notification.NotificationAddedEvent;
import com.atlassian.jira.event.notification.NotificationDeletedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeCopiedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeCreatedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeDeletedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.notification.NotificationType;
import com.atlassian.jira.notification.NotificationTypeManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.preferences.JiraUserPreferences;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.SMTPMailServer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultNotificationSchemeManager
extends AbstractSchemeManager
implements NotificationSchemeManager,
Startable {
    private static final Logger log = Logger.getLogger(DefaultNotificationSchemeManager.class);
    private static final String SCHEME_ENTITY_NAME = "NotificationScheme";
    private static final String NOTIFICATION_ENTITY_NAME = "Notification";
    private static final String SCHEME_DESC = "Notification";
    private static final String DEFAULT_NAME_KEY = "admin.schemes.notifications.default";
    private final OfBizDelegator delegator;
    private final EventPublisher eventPublisher;
    private final NotificationTypeManager notificationTypeManager;

    public DefaultNotificationSchemeManager(ProjectManager projectManager, PermissionTypeManager permissionTypeManager, PermissionContextFactory permissionContextFactory, OfBizDelegator delegator, SchemeFactory schemeFactory, EventPublisher eventPublisher, NotificationTypeManager notificationTypeManager, AssociationManager associationManager, GroupManager groupManager) {
        super(projectManager, permissionTypeManager, permissionContextFactory, schemeFactory, associationManager, delegator, groupManager);
        this.delegator = delegator;
        this.eventPublisher = eventPublisher;
        this.notificationTypeManager = notificationTypeManager;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @Override
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        super.onClearCache(event);
    }

    @Override
    public String getSchemeEntityName() {
        return SCHEME_ENTITY_NAME;
    }

    @Override
    public String getEntityName() {
        return "Notification";
    }

    @Override
    public String getSchemeDesc() {
        return "Notification";
    }

    @Override
    public String getDefaultNameKey() {
        return DEFAULT_NAME_KEY;
    }

    @Override
    public String getDefaultDescriptionKey() {
        return null;
    }

    @Override
    public Scheme createSchemeObject(String name, String description) {
        Scheme scheme = super.createSchemeObject(name, description);
        if (scheme != null) {
            this.eventPublisher.publish((Object)new NotificationSchemeCreatedEvent(scheme));
        }
        return scheme;
    }

    @Override
    public Scheme copyScheme(Scheme scheme) {
        Scheme result = super.copyScheme(scheme);
        if (result != null) {
            this.eventPublisher.publish((Object)new NotificationSchemeCopiedEvent(scheme, result));
        }
        return result;
    }

    @Override
    public void updateScheme(Scheme scheme) throws DataAccessException {
        super.updateScheme(scheme);
        this.eventPublisher.publish((Object)new NotificationSchemeUpdatedEvent(scheme));
    }

    @Override
    public void deleteScheme(Long id) throws GenericEntityException {
        super.deleteScheme(id);
        this.eventPublisher.publish((Object)new NotificationSchemeDeletedEvent(id));
    }

    @Override
    public GenericValue createDefaultScheme() throws GenericEntityException {
        if (this.getDefaultScheme() == null) {
            String name = this.getApplicationI18n().getText(DEFAULT_NAME_KEY);
            GenericValue defaultScheme = DEFAULT_NAME_KEY.equals(name) ? this.createSchemeGenericValue(EasyMap.build((Object)"name", (Object)"Default Notification Scheme", (Object)"description", null)) : this.createSchemeGenericValue(EasyMap.build((Object)"name", (Object)name, (Object)"description", null));
            return defaultScheme;
        }
        return this.getDefaultScheme();
    }

    public void removeSchemeEntitiesForField(String customFieldId) throws RemoveException {
        this.removeEntities("User_Custom_Field_Value", customFieldId);
        this.removeEntities("Group_Custom_Field_Value", customFieldId);
    }

    public List<SchemeEntity> getNotificationSchemeEntities(Project project, long entityTypeId) throws GenericEntityException {
        ArrayList schemeEntities = Lists.newArrayList();
        GenericValue notificationScheme = this.getNotificationSchemeForProject(project.getGenericValue());
        if (notificationScheme == null) {
            return schemeEntities;
        }
        List<GenericValue> entities = this.getEntities(notificationScheme, entityTypeId);
        for (GenericValue entity : entities) {
            schemeEntities.add(DefaultNotificationSchemeManager.makeSchemeEntity(entity));
        }
        return schemeEntities;
    }

    private static SchemeEntity makeSchemeEntity(GenericValue schemeEntityGV) {
        return new SchemeEntity(schemeEntityGV.getLong("id"), schemeEntityGV.getString("type"), schemeEntityGV.getString("parameter"), schemeEntityGV.get("eventTypeId"), schemeEntityGV.get("templateId"), schemeEntityGV.getLong("scheme"));
    }

    public GenericValue getNotificationSchemeForProject(GenericValue projectGV) {
        block3: {
            try {
                List<GenericValue> notificationSchemes = this.getSchemes(projectGV);
                if (notificationSchemes == null || notificationSchemes.isEmpty()) break block3;
                if (notificationSchemes.size() > 1) {
                    log.error((Object)("There are multiple notification schemes associated with the project: " + projectGV.getString("name") + ". " + "No emails will be sent for issue events in this project."));
                    break block3;
                }
                return notificationSchemes.get(0);
            }
            catch (GenericEntityException e) {
                log.error((Object)("There was an error retrieving the notification schemes for the project: " + projectGV.getString("name") + ". " + "No emails will be sent for issue events in this project."), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, String> getSchemesMapByConditions(Map<String, ?> conditions) {
        LinkedHashMap<Long, String> schemeMap = new LinkedHashMap<Long, String>();
        OfBizListIterator listIterator = null;
        Long schemeId = null;
        try {
            EntityFindOptions entityFindOptions = new EntityFindOptions();
            entityFindOptions.setDistinct(true);
            listIterator = this.delegator.findListIteratorByCondition("Notification", (EntityCondition)new EntityFieldMap(conditions, EntityOperator.AND), null, null, null, entityFindOptions);
            GenericValue resultMap = listIterator.next();
            while (resultMap != null) {
                if (resultMap.get("scheme") != null) {
                    schemeId = (Long)resultMap.get("scheme");
                    Scheme notificationScheme = this.getSchemeObject(schemeId);
                    schemeMap.put(schemeId, notificationScheme.getName());
                }
                resultMap = listIterator.next();
            }
        }
        finally {
            if (listIterator != null) {
                listIterator.close();
            }
        }
        return schemeMap;
    }

    public Collection<GenericValue> getSchemesContainingEntity(String type, String parameter) {
        Map conditions = EasyMap.build((Object)"type", (Object)type, (Object)"parameter", (Object)parameter);
        List entities = this.delegator.findByAnd("Notification", conditions);
        HashSet<Long> schemeIds = new HashSet<Long>();
        ArrayList<EntityExpr> entityConditions = new ArrayList<EntityExpr>();
        for (GenericValue schemeEntity : entities) {
            schemeIds.add(schemeEntity.getLong("scheme"));
        }
        for (Long id : schemeIds) {
            entityConditions.add(new EntityExpr("id", EntityOperator.EQUALS, (Object)id));
        }
        if (entityConditions.isEmpty()) {
            return Collections.emptyList();
        }
        return this.delegator.findByOr(SCHEME_ENTITY_NAME, entityConditions, Collections.emptyList());
    }

    public boolean isHasMailServer() throws MailException {
        try {
            SMTPMailServer smtp = MailFactory.getServerManager().getDefaultSMTPMailServer();
            return smtp != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public GenericValue createSchemeEntity(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        if (!(schemeEntity.getEntityTypeId() instanceof Long)) {
            throw new IllegalArgumentException("Notification scheme IDs must be Long values.");
        }
        GenericValue result = EntityUtils.createValue(this.getEntityName(), EasyMap.build((Object)"scheme", (Object)scheme.getLong("id"), (Object)"eventTypeId", (Object)schemeEntity.getEntityTypeId(), (Object)"type", (Object)schemeEntity.getType(), (Object)"parameter", (Object)schemeEntity.getParameter(), (Object)"templateId", (Object)schemeEntity.getTemplateId()));
        this.eventPublisher.publish((Object)new NotificationAddedEvent(scheme.getLong("id"), schemeEntity));
        return result;
    }

    @Override
    public void deleteEntity(Long id) throws DataAccessException {
        super.deleteEntity(id);
        this.eventPublisher.publish((Object)new NotificationDeletedEvent(id));
    }

    public Set<NotificationRecipient> getRecipients(IssueEvent event, SchemeEntity notification) throws GenericEntityException {
        JiraUserPreferences userPreference;
        HashSet<NotificationRecipient> recipients = new HashSet<NotificationRecipient>();
        NotificationType notificationType = this.notificationTypeManager.getNotificationType(notification.getType());
        List<NotificationRecipient> possibleRecipients = notificationType.getRecipients(event, notification.getParameter());
        for (NotificationRecipient recipient : possibleRecipients) {
            User userRecipient = recipient.getUserRecipient();
            if (userRecipient != null && !userRecipient.isActive()) continue;
            recipients.add(recipient);
        }
        User user = event.getUser();
        if (user != null && !(userPreference = new JiraUserPreferences(user)).getBoolean("user.notify.own.changes")) {
            recipients.remove(new NotificationRecipient(user));
            log.debug((Object)("Removed user " + user.getDisplayName() + " with email address " + user.getEmailAddress() + " from notification because they are the modifier and do not wish to be notified."));
        }
        return recipients;
    }

    public Set<NotificationRecipient> getRecipients(IssueEvent event) {
        Assertions.notNull((String)"issueEvent", (Object)event);
        LinkedHashSet<NotificationRecipient> ret = new LinkedHashSet<NotificationRecipient>();
        try {
            List<SchemeEntity> schemeEntities = this.getNotificationSchemeEntities(event.getProject(), event.getEventTypeId());
            for (SchemeEntity schemeEntity : schemeEntities) {
                ret.addAll(this.getRecipients(event, schemeEntity));
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)("There was an error accessing the notification scheme for the project: " + event.getProject() + "."), (Throwable)e);
        }
        return ret;
    }

    public boolean hasEntities(GenericValue scheme, Long eventTypeId, String type, String parameter, Long templateId) throws GenericEntityException {
        List entity = scheme.getRelatedByAnd("Child" + this.getEntityName(), EasyMap.build((Object)"eventTypeId", (Object)eventTypeId, (Object)"type", (Object)type, (Object)"parameter", (Object)parameter, (Object)"templateId", (Object)templateId));
        return entity != null && !entity.isEmpty();
    }

    @Override
    public GenericValue copySchemeEntity(GenericValue scheme, GenericValue entity) throws GenericEntityException {
        SchemeEntity schemeEntity = new SchemeEntity(entity.getLong("id"), entity.getString("type"), entity.getString("parameter"), (Object)entity.getLong("eventTypeId"), (Object)entity.getLong("templateId"), null);
        return this.createSchemeEntity(scheme, schemeEntity);
    }

    public List<GenericValue> getEntities(GenericValue scheme, String entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Notification scheme event type IDs must be Long values.");
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long eventTypeId) throws GenericEntityException {
        return scheme.getRelatedByAnd("Child" + this.getEntityName(), EasyMap.build((Object)"eventTypeId", (Object)eventTypeId));
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long eventTypeId, String parameter) throws GenericEntityException {
        return scheme.getRelatedByAnd("Child" + this.getEntityName(), EasyMap.build((Object)"eventTypeId", (Object)eventTypeId, (Object)"parameter", (Object)parameter));
    }

    public List<GenericValue> getEntities(GenericValue scheme, String type, Long entityTypeId) throws GenericEntityException {
        return scheme.getRelatedByAnd("Child" + this.getEntityName(), EasyMap.build((Object)"eventTypeId", (Object)entityTypeId, (Object)"type", (Object)type));
    }

    public boolean hasSchemeAuthority(Long entityType, GenericValue entity) {
        return false;
    }

    public boolean hasSchemeAuthority(Long entityType, GenericValue entity, User user, boolean issueCreation) {
        return false;
    }

    I18nHelper getApplicationI18n() {
        return new I18nBean((User)null);
    }
}

