/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.MailThreadManager;
import com.atlassian.mail.MailThreader;

public class JiraMailThreader
implements MailThreader {
    private Long eventTypeId;
    private Long issueId;

    public JiraMailThreader(Long eventTypeId, Long issueId) {
        this.eventTypeId = eventTypeId;
        this.issueId = issueId;
    }

    public void threadEmail(com.atlassian.mail.Email email) {
        if (!this.eventTypeId.equals(EventType.ISSUE_CREATED_ID) && this.isEventTypeValid() && email instanceof Email) {
            Email jiraEmail = (Email)email;
            ComponentAccessor.getMailThreadManager().threadNotificationEmail(jiraEmail, this.issueId);
        }
    }

    public void storeSentEmail(com.atlassian.mail.Email email) {
        if (this.isEventTypeValid()) {
            MailThreadManager mailThreadManager = ComponentAccessor.getMailThreadManager();
            mailThreadManager.createMailThread(mailThreadManager.getThreadType(this.eventTypeId), this.issueId, email.getTo(), email.getMessageId());
        }
    }

    private boolean isEventTypeValid() {
        return ComponentAccessor.getEventTypeManager().isEventTypeExists(this.eventTypeId);
    }
}

