/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.admin.enterprise;

import com.atlassian.jira.jelly.tag.UserAwareActionTagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;

public class CreateIssueSecurityScheme
extends UserAwareActionTagSupport {
    private static final Logger log = Logger.getLogger(CreateIssueSecurityScheme.class);
    private static final String KEY_SCHEMEID = "schemeId";
    private boolean hasPreviousIssueSchemeId = false;
    private Long previousIssueSchemeId = null;

    public CreateIssueSecurityScheme() {
        this.setActionName("AddIssueSecurityScheme");
        this.ignoreErrors = false;
    }

    @Override
    protected void postTagExecution(XMLOutput output) {
        log.debug((Object)"CreatePermissionScheme.postTagExecution");
        this.copyRedirectUrlParametersToTag(this.getResponse().getRedirectUrl());
        try {
            this.setPreviousIssueSchemeId((Long)this.getContext().getVariable("jelly.issue.scheme.id"));
            this.getContext().setVariable("jelly.issue.scheme.id", (Object)new Long(this.getProperty(KEY_SCHEMEID)));
        }
        catch (NumberFormatException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    protected void endTagExecution(XMLOutput output) {
        if (this.hasPreviousIssueSchemeId) {
            this.getContext().setVariable("jelly.issue.scheme.id", (Object)this.getPreviousIssueSchemeId());
        }
    }

    @Override
    public String[] getRequiredProperties() {
        return new String[0];
    }

    @Override
    public String[] getRequiredContextVariablesAfter() {
        return new String[]{"jelly.issue.scheme.id"};
    }

    public Long getPreviousIssueSchemeId() {
        return this.previousIssueSchemeId;
    }

    public void setPreviousIssueSchemeId(Long previousIssueSchemeId) {
        this.hasPreviousIssueSchemeId = true;
        this.previousIssueSchemeId = previousIssueSchemeId;
    }
}

