/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionQueryFactory;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterCache;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.security.type.SecurityType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultPermissionQueryFactory
implements PermissionQueryFactory {
    private static final Logger log = Logger.getLogger(DefaultPermissionQueryFactory.class);
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final PermissionManager permissionManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final PermissionTypeManager permissionTypeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final SecurityTypeManager issueSecurityTypeManager;
    private final ProjectFactory projectFactory;

    public DefaultPermissionQueryFactory(IssueSecurityLevelManager issueSecurityLevelManager, PermissionManager permissionManager, PermissionSchemeManager permissionSchemeManager, PermissionTypeManager permissionTypeManager, IssueSecuritySchemeManager issueSecuritySchemeManager, SecurityTypeManager issueSecurityTypeManager, ProjectFactory projectFactory) {
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.permissionManager = permissionManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.permissionTypeManager = permissionTypeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.issueSecurityTypeManager = issueSecurityTypeManager;
        this.projectFactory = projectFactory;
    }

    @Override
    public Query getQuery(User searcher, int permissionId) {
        try {
            BooleanQuery query = new BooleanQuery();
            Collection projects = this.permissionManager.getProjects(permissionId, searcher);
            LinkedHashSet<Query> projectQueries = new LinkedHashSet<Query>();
            for (GenericValue projectGV : projects) {
                this.collectProjectTerms(projectGV, searcher, projectQueries, permissionId);
            }
            BooleanQuery permissionQuery = new BooleanQuery();
            for (Query projectQuery : projectQueries) {
                permissionQuery.add(projectQuery, BooleanClause.Occur.SHOULD);
            }
            if (!permissionQuery.clauses().isEmpty()) {
                query.add((Query)permissionQuery, BooleanClause.Occur.MUST);
                LinkedHashSet<Query> issueLevelSecurityQueries = new LinkedHashSet<Query>();
                issueLevelSecurityQueries.add((Query)new TermQuery(new Term(SystemSearchConstants.forSecurityLevel().getIndexField(), "-1")));
                try {
                    for (GenericValue projectGV : projects) {
                        this.collectSecurityLevelTerms(projectGV, searcher, issueLevelSecurityQueries);
                    }
                }
                catch (GenericEntityException e) {
                    log.error((Object)"Error occurred retrieving security levels for this user");
                }
                BooleanQuery issueLevelQuery = new BooleanQuery();
                for (Query issueLevelSecurityQuery : issueLevelSecurityQueries) {
                    issueLevelQuery.add(issueLevelSecurityQuery, BooleanClause.Occur.SHOULD);
                }
                query.add((Query)issueLevelQuery, BooleanClause.Occur.MUST);
            }
            return query;
        }
        catch (GenericEntityException e) {
            log.error((Object)("Error constructing query: " + (Object)((Object)e)), (Throwable)e);
            return null;
        }
    }

    PermissionsFilterCache getCache() {
        PermissionsFilterCache cache = (PermissionsFilterCache)JiraAuthenticationContextImpl.getRequestCache().get("jira.permissions.filter.cache");
        if (cache == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating new PermissionsFilterCache");
            }
            cache = new PermissionsFilterCache();
            JiraAuthenticationContextImpl.getRequestCache().put("jira.permissions.filter.cache", cache);
        }
        return cache;
    }

    void collectProjectTerms(GenericValue projectGV, User searcher, Set<Query> queries, int permissionId) throws GenericEntityException {
        List schemes = this.permissionSchemeManager.getSchemes(projectGV);
        for (GenericValue scheme : schemes) {
            List entities = this.permissionSchemeManager.getEntities(scheme, Long.valueOf(permissionId));
            for (GenericValue entity : entities) {
                SecurityType securityType = this.permissionTypeManager.getSecurityType(entity.getString("type"));
                try {
                    Query tempQuery;
                    if (!this.userHasPermissionForProjectAndSecurityType(searcher, projectGV, entity, securityType) || (tempQuery = securityType.getQuery(searcher, projectGV, entity.getString("parameter"))) == null) continue;
                    queries.add(tempQuery);
                }
                catch (Exception e) {
                    log.error((Object)("Could not add query for security type:" + securityType.getDisplayName()), (Throwable)e);
                }
            }
        }
    }

    void collectSecurityLevelTerms(GenericValue project, User searcher, Set<Query> queries) throws GenericEntityException {
        List usersSecurityLevels = this.issueSecurityLevelManager.getUsersSecurityLevels(project, searcher);
        for (GenericValue securityLevel : usersSecurityLevels) {
            List securities = this.issueSecuritySchemeManager.getEntitiesBySecurityLevel(securityLevel.getLong("id"));
            for (GenericValue entity : securities) {
                Project projectObject;
                Query tempQuery;
                SecurityType securityType;
                if (!this.userHasPermissionForProjectAndSecurityType(searcher, project, entity, securityType = this.issueSecurityTypeManager.getSecurityType(entity.getString("type"))) || (tempQuery = securityType.getQuery(searcher, projectObject = this.projectFactory.getProject(project), securityLevel, entity.getString("parameter"))) == null) continue;
                queries.add(tempQuery);
            }
        }
    }

    boolean userHasPermissionForProjectAndSecurityType(User searcher, GenericValue project, GenericValue entity, SecurityType securityType) {
        boolean hasPermission = searcher == null ? securityType.hasPermission(project, entity.getString("parameter")) : securityType.hasPermission(project, entity.getString("parameter"), searcher, false);
        return hasPermission;
    }
}

